/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.proxy;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Vector;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.core.proxy.ProxyParam;
import org.parosproxy.paros.core.proxy.ProxyThread;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpUtil;
import org.parosproxy.paros.network.SSLConnector;

public class ProxyServer
implements Runnable {
    protected Thread thread = null;
    protected static final int PORT_TIME_OUT = 2000;
    protected ServerSocket proxySocket = null;
    protected boolean isProxyRunning = false;
    protected ProxyParam proxyParam = new ProxyParam();
    protected ConnectionParam connectionParam = new ConnectionParam();
    protected Vector listenerList = new Vector();
    protected boolean serialize = false;

    public boolean isSerialize() {
        return this.serialize;
    }

    public void setProxyParam(ProxyParam proxyParam) {
        this.proxyParam = proxyParam;
    }

    public ProxyParam getProxyParam() {
        return this.proxyParam;
    }

    public void setConnectionParam(ConnectionParam connectionParam) {
        this.connectionParam = connectionParam;
    }

    public ConnectionParam getConnectionParam() {
        return this.connectionParam;
    }

    public synchronized boolean startServer() {
        if (this.isProxyRunning) {
            this.stopServer();
        }
        this.isProxyRunning = false;
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.setPriority(6);
        try {
            this.proxySocket = this.createServerSocket();
            this.proxySocket.setSoTimeout(2000);
            this.isProxyRunning = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        this.thread.start();
        return true;
    }

    public synchronized boolean stopServer() {
        if (!this.isProxyRunning) {
            return false;
        }
        this.isProxyRunning = false;
        try {
            this.thread.join(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HttpUtil.closeServerSocket(this.proxySocket);
        this.proxySocket = null;
        return true;
    }

    public void run() {
        Socket socket = null;
        ProxyThread proxyThread = null;
        while (this.isProxyRunning) {
            try {
                socket = this.proxySocket.accept();
                proxyThread = this.createProxyProcess(socket);
                proxyThread.start();
            }
            catch (IOException iOException) {}
        }
    }

    protected ServerSocket createServerSocket() throws UnknownHostException, IOException {
        ServerSocket serverSocket = new ServerSocket(this.getProxyParam().getProxyPort(), 300, InetAddress.getByName(this.getProxyParam().getProxyIp()));
        return serverSocket;
    }

    protected ProxyThread createProxyProcess(Socket socket) {
        ProxyThread proxyThread = new ProxyThread(this, socket);
        return proxyThread;
    }

    protected void writeOutput(String string) {
    }

    public void addProxyListener(ProxyListener proxyListener) {
        this.listenerList.add(proxyListener);
    }

    public void removeProxyListener(ProxyListener proxyListener) {
        this.listenerList.remove(proxyListener);
    }

    synchronized List getListenerList() {
        return this.listenerList;
    }

    public void setSerialize(boolean bl) {
        this.serialize = bl;
    }

    static {
        Protocol.registerProtocol("https", new Protocol("https", (ProtocolSocketFactory)new SSLConnector(), 443));
    }
}

