/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.spider;

import java.net.URLEncoder;
import java.util.Vector;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.core.spider.A;
import org.parosproxy.paros.core.spider.Form;
import org.parosproxy.paros.core.spider.Frame;
import org.parosproxy.paros.core.spider.Html;
import org.parosproxy.paros.core.spider.Img;
import org.parosproxy.paros.core.spider.Input;
import org.parosproxy.paros.core.spider.Select;
import org.parosproxy.paros.core.spider.SpiderThread;
import org.parosproxy.paros.core.spider.Tag;
import org.parosproxy.paros.network.HttpBody;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;

public class Collector {
    private SpiderThread parent = null;
    private static final String EQUAL = "=";
    private static final String AMPERSAND = "&";
    private static final String QUESTION = "?";

    Collector(SpiderThread spiderThread) {
        this.parent = spiderThread;
    }

    private HttpMessage buildMsg(URI uRI, String string) throws URIException, HttpMalformedHeaderException {
        URI uRI2 = null;
        uRI2 = new URI(uRI, string, true);
        HttpMessage httpMessage = new HttpMessage(new HttpRequestHeader("GET", uRI2));
        return httpMessage;
    }

    void collect(Html html, int n) {
        String string;
        int n2;
        Object var3_3 = null;
        A[] aArray = html.getAs();
        Frame[] frameArray = html.getFrames();
        Img[] imgArray = html.getImgs();
        HttpMessage httpMessage = null;
        for (n2 = 0; n2 < aArray.length; ++n2) {
            string = aArray[n2].getHref();
            try {
                httpMessage = this.buildMsg(html.getURI(), string);
                this.parent.foundURI(httpMessage, html.getURI().toString(), n);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (n2 = 0; n2 < frameArray.length; ++n2) {
            string = frameArray[n2].getSrc();
            try {
                httpMessage = this.buildMsg(html.getURI(), string);
                this.parent.foundURI(httpMessage, html.getURI().toString(), n);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Vector vector = this.getFormsQuery(html);
        for (int i = 0; i < vector.size(); ++i) {
            httpMessage = (HttpMessage)vector.get(i);
            try {
                this.parent.foundURI(httpMessage, html.getURI().toString(), n);
                continue;
            }
            catch (URIException uRIException) {
                // empty catch block
            }
        }
    }

    public Vector getFormsQuery(Html html) {
        Vector vector = new Vector();
        Form[] formArray = html.getForms();
        for (int i = 0; i < formArray.length; ++i) {
            Form form = formArray[i];
            Vector vector2 = this.getFormQuery(form, html.getURI());
            vector.addAll(vector2);
        }
        return vector;
    }

    private Vector getFormQuery(Form form, URI uRI) {
        int n;
        Vector vector = new Vector();
        Vector<Object> vector2 = new Vector<Object>();
        String string = "";
        HttpRequestHeader httpRequestHeader = null;
        HttpBody httpBody = null;
        if (form.getAction() == null || form.getAction().equals("")) {
            return vector2;
        }
        int n2 = 1;
        for (n = 0; n < form.getSelect().length; ++n) {
            n2 *= form.getSelect()[n].getOption().length > 3 ? 3 : form.getSelect()[n].getOption().length;
        }
        if (n2 > 20000) {
            return vector2;
        }
        try {
            Object object;
            for (n = 0; n < form.getInput().length; ++n) {
                object = form.getInput()[n];
                if (((Input)object).getType() != null && (((Input)object).getType().equalsIgnoreCase("SUBMIT") || ((Input)object).getType().equalsIgnoreCase("PASSWORD") || ((Input)object).getType().equalsIgnoreCase("CHECKBOX") || ((Input)object).getType().equalsIgnoreCase("RESET"))) continue;
                string = this.buildPostQueryString(string, ((Tag)object).getName(), ((Input)object).getValue());
            }
            vector.addElement(string);
            for (n = 0; n < form.getSelect().length; ++n) {
                object = form.getSelect()[n];
                vector = this.addSelectField(vector, (Select)object);
            }
            for (n = 0; n < vector.size(); ++n) {
                object = null;
                URI uRI2 = null;
                String string2 = (String)vector.elementAt(n);
                if (form.getMethod().equalsIgnoreCase("GET")) {
                    String string3 = form.getAction().indexOf(QUESTION) < 0 ? form.getAction() + QUESTION + string2 : form.getAction() + AMPERSAND + string2;
                    uRI2 = new URI(uRI, string3, true);
                    httpRequestHeader = new HttpRequestHeader(form.getMethod().trim().toUpperCase(), uRI2);
                    object = new HttpMessage(httpRequestHeader);
                } else {
                    if (!form.getMethod().equalsIgnoreCase("POST")) continue;
                    uRI2 = new URI(uRI, form.getAction(), true);
                    httpRequestHeader = new HttpRequestHeader(form.getMethod().trim().toUpperCase(), uRI2);
                    httpBody = new HttpBody(string2);
                    httpRequestHeader.setContentLength(httpBody.length());
                    object = new HttpMessage(httpRequestHeader, httpBody);
                }
                vector2.add(object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector2;
    }

    private Vector addSelectField(Vector vector, Select select) {
        Vector<String> vector2 = new Vector<String>();
        String string = null;
        if (select.option == null) {
            return vector2;
        }
        for (int i = 0; i < select.option.length || i < 3; ++i) {
            String string2 = select.option[i].getValue();
            try {
                if (vector.isEmpty()) {
                    string = this.buildPostQueryString("", select.getName(), string2);
                    vector2.addElement(string);
                    continue;
                }
                for (int j = 0; j < vector.size(); ++j) {
                    string = (String)vector.elementAt(j);
                    string = this.buildPostQueryString(string, select.getName(), string2);
                    vector2.addElement(string);
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vector2;
    }

    private String buildPostQueryString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string.length() > 0) {
            stringBuffer.append(AMPERSAND);
        }
        stringBuffer.append(string2);
        stringBuffer.append(EQUAL);
        stringBuffer.append(URLEncoder.encode(string3));
        return stringBuffer.toString();
    }
}

