/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.spider;

import java.util.HashSet;
import java.util.Vector;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.parosproxy.paros.core.spider.HttpMessageQueue;
import org.parosproxy.paros.core.spider.QueueItem;
import org.parosproxy.paros.core.spider.SpiderListener;
import org.parosproxy.paros.core.spider.SpiderParam;
import org.parosproxy.paros.core.spider.SpiderThread;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;

public class Spider {
    private static Log log = LogFactory.getLog(class$org$parosproxy$paros$core$spider$Spider == null ? (class$org$parosproxy$paros$core$spider$Spider = Spider.class$("org.parosproxy.paros.core.spider.Spider")) : class$org$parosproxy$paros$core$spider$Spider);
    private HttpSender httpSender = null;
    private boolean isSubmitForm = true;
    private Vector listenerList = new Vector();
    private ConnectionParam connectionParam = null;
    private Vector queue = new Vector();
    private SpiderThread[] spiderThread = null;
    private HttpMessageQueue visitedLink = new HttpMessageQueue();
    private SpiderParam spiderParam = null;
    private HashSet seedHostNameSet = new HashSet();
    private int[] depthQueueCount = null;
    static /* synthetic */ Class class$org$parosproxy$paros$core$spider$Spider;

    public Spider(SpiderParam spiderParam, ConnectionParam connectionParam) {
        this.connectionParam = connectionParam;
        this.spiderParam = spiderParam;
        this.spiderThread = new SpiderThread[spiderParam.getThread()];
        this.httpSender = new HttpSender(connectionParam);
        this.httpSender.setFollowRedirect(true);
        this.depthQueueCount = new int[spiderParam.getMaxDepth() + 1];
    }

    public void addSpiderListener(SpiderListener spiderListener) {
        this.listenerList.add(spiderListener);
    }

    public synchronized void addSeed(HttpMessage httpMessage) {
        URI uRI = httpMessage.getRequestHeader().getURI();
        String string = null;
        int n = 80;
        try {
            log.info("seeding " + httpMessage.getRequestHeader().getURI().toString());
            string = uRI.getHost();
            n = uRI.getPort();
            if (n > 0) {
                string = string + ":" + Integer.toString(n);
            }
            this.seedHostNameSet.add(string);
            this.addQueue(httpMessage, 0);
        }
        catch (URIException uRIException) {
            uRIException.printStackTrace();
        }
    }

    public synchronized void addQueue(HttpMessage httpMessage, int n) {
        if (n > this.spiderParam.getMaxDepth() || this.getVisitedLink().contains(httpMessage)) {
            return;
        }
        for (int i = 0; i < this.queue.size(); ++i) {
            QueueItem queueItem = (QueueItem)this.queue.get(i);
            if (!queueItem.equals(httpMessage)) continue;
            return;
        }
        QueueItem queueItem = new QueueItem(httpMessage);
        queueItem.setDepth(n);
        this.queue.add(queueItem);
        if (n < this.depthQueueCount.length) {
            int n2 = n;
            this.depthQueueCount[n2] = this.depthQueueCount[n2] + 1;
        }
    }

    void checkIfAllThreadCompleted() {
        for (int i = 0; i < this.spiderThread.length; ++i) {
            if (this.spiderThread[i].isCompleted()) continue;
            return;
        }
        this.notifyListenerSpiderComplete();
    }

    public HttpSender getHttpSender() {
        return this.httpSender;
    }

    public Vector getQueue() {
        return this.queue;
    }

    public HttpMessageQueue getVisitedLink() {
        return this.visitedLink;
    }

    private void notifyListenerFoundURI(HttpMessage httpMessage) {
        SpiderListener spiderListener = null;
        for (int i = 0; i < this.listenerList.size(); ++i) {
            spiderListener = (SpiderListener)this.listenerList.get(i);
            spiderListener.foundURI(httpMessage);
        }
    }

    private void notifyListenerSpiderComplete() {
        SpiderListener spiderListener = null;
        this.notifyListenerSpiderProgress(null, 100);
        for (int i = 0; i < this.listenerList.size(); ++i) {
            spiderListener = (SpiderListener)this.listenerList.get(i);
            spiderListener.spiderComplete();
        }
        log.info("Spider completed");
    }

    synchronized void SpiderProgress(QueueItem queueItem) {
        int n = 100 / (this.spiderParam.getMaxDepth() + 1);
        int n2 = n * queueItem.getDepth();
        int n3 = 0;
        for (int i = 0; i < this.queue.size(); ++i) {
            QueueItem queueItem2 = (QueueItem)this.queue.get(i);
            if (queueItem2 == null || queueItem2.getDepth() > queueItem.getDepth()) continue;
            ++n3;
        }
        n2 += n * (this.depthQueueCount[queueItem.getDepth()] - n3) / this.depthQueueCount[queueItem.getDepth()];
        try {
            this.notifyListenerSpiderProgress(queueItem.getMessage().getRequestHeader().getURI(), n2);
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void notifyListenerSpiderProgress(URI uRI, int n) {
        SpiderListener spiderListener = null;
        for (int i = 0; i < this.listenerList.size(); ++i) {
            spiderListener = (SpiderListener)this.listenerList.get(i);
            spiderListener.spiderProgress(uRI, n);
        }
    }

    private void notifyListenerReadURI(HttpMessage httpMessage) {
        SpiderListener spiderListener = null;
        log.info("crawled " + httpMessage.getRequestHeader().getURI().toString());
        for (int i = 0; i < this.listenerList.size(); ++i) {
            spiderListener = (SpiderListener)this.listenerList.get(i);
            spiderListener.readURI(httpMessage);
        }
    }

    public void removeSpiderListener(SpiderListener spiderListener) {
        this.listenerList.remove(spiderListener);
    }

    public SpiderParam getSpiderParam() {
        return this.spiderParam;
    }

    public void setSpiderParam(SpiderParam spiderParam) {
        this.spiderParam = spiderParam;
    }

    public void setVisitedLink(HttpMessageQueue httpMessageQueue) {
        this.visitedLink = httpMessageQueue;
    }

    public void start() {
        log.info("spider started.");
        for (int i = 0; i < this.spiderThread.length; ++i) {
            if (this.spiderThread[i] != null && this.spiderThread[i].isAlive()) {
                this.spiderThread[i].setStop(true);
            }
            this.spiderThread[i] = new SpiderThread(this);
            this.spiderThread[i].start();
        }
    }

    public void stop() {
        for (int i = 0; i < this.spiderThread.length; ++i) {
            this.spiderThread[i].setStop(true);
            try {
                this.spiderThread[i].join(4000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        log.info("spider stopped.");
    }

    public boolean isSeedScope(URI uRI) {
        boolean bl = false;
        String string = null;
        try {
            string = uRI.getHost();
            if (uRI.getPort() > 0) {
                string = string + ":" + uRI.getPort();
            }
            String[] stringArray = this.seedHostNameSet.toArray(new String[0]);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || !string.endsWith(stringArray[i])) continue;
                return true;
            }
        }
        catch (URIException uRIException) {
            uRIException.printStackTrace();
        }
        return false;
    }

    void foundURI(HttpMessage httpMessage) {
        this.notifyListenerFoundURI(httpMessage);
    }

    void readURI(HttpMessage httpMessage) {
        this.notifyListenerReadURI(httpMessage);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

