/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.spider;

import java.util.regex.Pattern;
import org.parosproxy.paros.common.FileXML;

public class SpiderParam
extends FileXML {
    private static final String SPIDER = "spider";
    private static final String SPIDER_MAX_DEPTH = "maxDepth";
    private static final String SPIDER_THREAD = "thread";
    private static final String SPIDER_SCOPE = "scope";
    private static final String[] PATH_SPIDER_MAX_DEPTH = new String[]{"spider", "maxDepth"};
    private static final String[] PATH_SPIDER_THREAD = new String[]{"spider", "thread"};
    private static final String[] PATH_SPIDER_SCOPE = new String[]{"spider", "scope"};
    private int maxDepth = 5;
    private int thread = 2;
    private String scope = "";
    private Pattern patternScope = null;

    public SpiderParam() {
        super(SPIDER);
    }

    protected void parse() throws Exception {
        try {
            this.setThread(Integer.parseInt(this.getValue(SPIDER_THREAD)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setMaxDepth(Integer.parseInt(this.getValue(SPIDER_MAX_DEPTH)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setScope(this.getValue(SPIDER_SCOPE));
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int n) {
        this.maxDepth = n;
        this.setValue(PATH_SPIDER_MAX_DEPTH, Integer.toString(this.maxDepth));
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String string) {
        this.scope = string;
        this.setValue(PATH_SPIDER_SCOPE, this.scope);
        this.parseScope(this.scope);
    }

    public int getThread() {
        return this.thread;
    }

    public void setThread(int n) {
        this.thread = n;
        this.setValue(PATH_SPIDER_THREAD, Integer.toString(this.thread));
    }

    public boolean isInScope(String string) {
        if (this.patternScope == null || string == null) {
            return false;
        }
        return this.patternScope.matcher(string).find();
    }

    private void parseScope(String string) {
        this.patternScope = null;
        if (string == null || string.equals("")) {
            return;
        }
        string = string.replaceAll("\\.", "\\\\.");
        string = string.replaceAll("\\*", ".*?").replaceAll("(;+$)|(^;+)", "");
        string = "(" + string.replaceAll(";+", "|") + ")$";
        this.patternScope = Pattern.compile(string, 2);
    }
}

