/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.parosproxy.paros.db.AbstractTable;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;

public class TableHistory
extends AbstractTable {
    private static final String HISTORYID = "HISTORYID";
    private static final String SESSIONID = "SESSIONID";
    private static final String HISTTYPE = "HISTTYPE";
    private static final String REQHEADER = "REQHEADER";
    private static final String REQBODY = "REQBODY";
    private static final String RESHEADER = "RESHEADER";
    private static final String RESBODY = "RESBODY";
    private PreparedStatement psRead = null;
    private PreparedStatement psWrite1 = null;
    private CallableStatement psWrite2 = null;
    private PreparedStatement psReadSession = null;
    private PreparedStatement psReadSearch = null;
    private PreparedStatement psDelete = null;
    private PreparedStatement psDeleteTemp = null;

    protected void reconnect(Connection connection) throws SQLException {
        this.psRead = connection.prepareStatement("SELECT TOP 1 * FROM HISTORY WHERE HISTORYID = ?");
        this.psWrite1 = connection.prepareStatement("INSERT INTO HISTORY (SESSIONID,HISTTYPE,REQHEADER,REQBODY,RESHEADER,RESBODY) VALUES (?, ?, ?, ?, ?, ?)");
        this.psWrite2 = connection.prepareCall("CALL IDENTITY();");
        this.psReadSession = connection.prepareStatement("SELECT HISTORYID FROM HISTORY WHERE SESSIONID = ? AND HISTTYPE = ? ORDER BY HISTORYID");
        this.psReadSearch = connection.prepareStatement("SELECT * FROM HISTORY WHERE SESSIONID = ? AND HISTTYPE = ? ORDER BY HISTORYID");
        this.psDelete = connection.prepareStatement("DELETE FROM HISTORY WHERE HISTORYID = ?");
        this.psDeleteTemp = connection.prepareStatement("DELETE FROM HISTORY WHERE HISTTYPE = 0");
    }

    public synchronized RecordHistory read(int n) throws HttpMalformedHeaderException, SQLException {
        this.psRead.setInt(1, n);
        this.psRead.execute();
        ResultSet resultSet = this.psRead.getResultSet();
        return this.build(resultSet);
    }

    public synchronized RecordHistory write(long l, int n, HttpMessage httpMessage) throws HttpMalformedHeaderException, SQLException {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (!httpMessage.getRequestHeader().isEmpty()) {
            string = httpMessage.getRequestHeader().toString();
            string2 = httpMessage.getRequestBody().toString();
        }
        if (!httpMessage.getResponseHeader().isEmpty()) {
            string3 = httpMessage.getResponseHeader().toString();
            string4 = httpMessage.getResponseBody().toString();
        }
        return this.write(l, n, string, string2, string3, string4);
    }

    private synchronized RecordHistory write(long l, int n, String string, String string2, String string3, String string4) throws HttpMalformedHeaderException, SQLException {
        this.psWrite1.setLong(1, l);
        this.psWrite1.setInt(2, n);
        this.psWrite1.setString(3, string);
        this.psWrite1.setString(4, string2);
        this.psWrite1.setString(5, string3);
        this.psWrite1.setString(6, string4);
        this.psWrite1.executeUpdate();
        this.psWrite2.executeQuery();
        ResultSet resultSet = this.psWrite2.getResultSet();
        resultSet.next();
        int n2 = resultSet.getInt(1);
        return this.read(n2);
    }

    private RecordHistory build(ResultSet resultSet) throws HttpMalformedHeaderException, SQLException {
        RecordHistory recordHistory = null;
        if (resultSet.next()) {
            recordHistory = new RecordHistory(resultSet.getInt(HISTORYID), resultSet.getInt(HISTTYPE), resultSet.getString(REQHEADER), resultSet.getString(REQBODY), resultSet.getString(RESHEADER), resultSet.getString(RESBODY));
        }
        return recordHistory;
    }

    public Vector getHistoryList(long l, int n) throws SQLException {
        Vector<Integer> vector = new Vector<Integer>();
        this.psReadSession.setLong(1, l);
        this.psReadSession.setInt(2, n);
        this.psReadSession.executeQuery();
        ResultSet resultSet = this.psReadSession.getResultSet();
        while (resultSet.next()) {
            vector.add(new Integer(resultSet.getInt(HISTORYID)));
        }
        return vector;
    }

    public List getHistoryList(long l, int n, String string, boolean bl) throws SQLException {
        Pattern pattern = Pattern.compile(string, 10);
        Matcher matcher = null;
        Vector<Integer> vector = new Vector<Integer>();
        this.psReadSearch.setLong(1, l);
        this.psReadSearch.setInt(2, n);
        this.psReadSearch.executeQuery();
        ResultSet resultSet = this.psReadSearch.getResultSet();
        while (resultSet.next()) {
            if (bl) {
                matcher = pattern.matcher(resultSet.getString(REQHEADER));
                if (matcher.find()) {
                    vector.add(new Integer(resultSet.getInt(HISTORYID)));
                    continue;
                }
                matcher = pattern.matcher(resultSet.getString(REQBODY));
                if (!matcher.find()) continue;
                vector.add(new Integer(resultSet.getInt(HISTORYID)));
                continue;
            }
            matcher = pattern.matcher(resultSet.getString(RESHEADER));
            if (matcher.find()) {
                vector.add(new Integer(resultSet.getInt(HISTORYID)));
                continue;
            }
            matcher = pattern.matcher(resultSet.getString(RESBODY));
            if (!matcher.find()) continue;
            vector.add(new Integer(resultSet.getInt(HISTORYID)));
        }
        return vector;
    }

    public void deleteHistorySession(long l) throws SQLException {
        Statement statement = this.getConnection().createStatement();
        statement.executeUpdate("DELETE FROM HISTORY WHERE SESSIONID = " + l);
    }

    public void delete(int n) throws SQLException {
        this.psDelete.setInt(1, n);
        this.psDelete.executeUpdate();
    }

    public void deleteTemporary() throws SQLException {
        this.psDeleteTemp.execute();
    }
}

