/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension;

import java.awt.Component;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.parosproxy.paros.control.Proxy;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionHookMenu;
import org.parosproxy.paros.extension.ExtensionHookView;
import org.parosproxy.paros.extension.ExtensionPopupMenu;
import org.parosproxy.paros.extension.OptionsListener;
import org.parosproxy.paros.extension.SessionListener;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.AbstractParamDialog;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.MainMenuBar;
import org.parosproxy.paros.view.TabbedPanel;
import org.parosproxy.paros.view.View;

public class ExtensionLoader {
    private Vector extensionList = new Vector();
    private Vector hookList = new Vector();
    private View view = null;
    private Model model = null;

    public ExtensionLoader(Model model, View view) {
        this.model = model;
        this.view = view;
    }

    private void addParamPanel(List list, AbstractParamDialog abstractParamDialog) {
        AbstractParamPanel abstractParamPanel = null;
        String[] stringArray = new String[]{};
        for (int i = 0; i < list.size(); ++i) {
            try {
                abstractParamPanel = (AbstractParamPanel)list.get(i);
                abstractParamDialog.addParamPanel(stringArray, abstractParamPanel);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addExtension(Extension extension) {
        this.extensionList.add(extension);
    }

    private void addTabPanel(List list, TabbedPanel tabbedPanel) {
        AbstractPanel abstractPanel = null;
        for (int i = 0; i < list.size(); ++i) {
            try {
                abstractPanel = (AbstractPanel)list.get(i);
                tabbedPanel.add((Component)abstractPanel, abstractPanel.getName());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void destroyAllExtension() {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            this.getExtension(i).destroy();
        }
    }

    public Extension getExtension(int n) {
        return (Extension)this.extensionList.get(n);
    }

    public Extension getExtension(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this.extensionList.size(); ++i) {
            Extension extension = this.getExtension(i);
            if (!extension.getName().equalsIgnoreCase(string)) continue;
            return extension;
        }
        return null;
    }

    public int getExtensionCount() {
        return this.extensionList.size();
    }

    private void initAllExtension() {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            this.getExtension(i).init();
        }
    }

    private void initModelAllExtension(Model model) {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            this.getExtension(i).initModel(model);
        }
    }

    private void hookMenu(View view, ExtensionHook extensionHook) {
        int n;
        int n2;
        if (view == null) {
            return;
        }
        if (extensionHook.getHookMenu() == null) {
            return;
        }
        ExtensionHookMenu extensionHookMenu = extensionHook.getHookMenu();
        List list = null;
        JMenuItem jMenuItem = null;
        JMenu jMenu = null;
        JMenu jMenu2 = view.getMainFrame().getMainMenuBar().getMenuTools();
        JMenu jMenu3 = view.getMainFrame().getMainMenuBar().getMenuEdit();
        JMenu jMenu4 = view.getMainFrame().getMainMenuBar().getMenuView();
        MainMenuBar mainMenuBar = view.getMainFrame().getMainMenuBar();
        list = extensionHookMenu.getNewMenus();
        for (n2 = 0; n2 < list.size(); ++n2) {
            jMenu = (JMenu)list.get(n2);
            mainMenuBar.add((Component)jMenu, mainMenuBar.getMenuCount() - 2);
        }
        list = extensionHookMenu.getTools();
        n2 = 2;
        for (n = 0; n < list.size(); ++n) {
            jMenuItem = (JMenuItem)list.get(n);
            if (jMenuItem == null) continue;
            jMenu2.add((Component)jMenuItem, jMenu2.getItemCount() - n2);
        }
        list = extensionHookMenu.getEdit();
        for (n = 0; n < list.size(); ++n) {
            jMenuItem = (JMenuItem)list.get(n);
            if (jMenuItem == null) continue;
            jMenu3.add((Component)jMenuItem, jMenu3.getItemCount());
        }
        list = extensionHookMenu.getView();
        for (n = 0; n < list.size(); ++n) {
            jMenuItem = (JMenuItem)list.get(n);
            if (jMenuItem == null) continue;
            jMenu4.add((Component)jMenuItem, jMenu4.getItemCount());
        }
        list = extensionHookMenu.getPopupMenus();
        for (n = 0; n < list.size(); ++n) {
            jMenuItem = (ExtensionPopupMenu)list.get(n);
            if (jMenuItem == null) continue;
            view.getPopupList().add(jMenuItem);
        }
    }

    private void hookView(View view, ExtensionHook extensionHook) {
        if (view == null) {
            return;
        }
        ExtensionHookView extensionHookView = extensionHook.getHookView();
        if (extensionHookView == null) {
            return;
        }
        this.addTabPanel(extensionHookView.getSelectPanel(), view.getWorkbench().getTabbedSelect());
        this.addTabPanel(extensionHookView.getWorkPanel(), view.getWorkbench().getTabbedWork());
        this.addTabPanel(extensionHookView.getStatusPanel(), view.getWorkbench().getTabbedStatus());
        this.addParamPanel(extensionHookView.getSessionPanel(), view.getSessionDialog(""));
        this.addParamPanel(extensionHookView.getOptionsPanel(), view.getOptionsDialog(""));
    }

    private void initViewAllExtension(View view) {
        if (view == null) {
            return;
        }
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            this.getExtension(i).initView(view);
        }
    }

    private void initXMLAllExtension(Session session, OptionsParam optionsParam) {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            this.getExtension(i).initXML(session, optionsParam);
        }
    }

    public void startAllExtension() {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            this.getExtension(i).start();
        }
    }

    private void hookAllExtension() {
        ExtensionHook extensionHook = null;
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            extensionHook = new ExtensionHook(this.model, this.view);
            this.getExtension(i).hook(extensionHook);
            this.hookList.add(extensionHook);
            this.hookView(this.view, extensionHook);
            this.hookMenu(this.view, extensionHook);
        }
        if (this.view != null) {
            this.view.getMainFrame().getMainMenuBar().validate();
            this.view.getMainFrame().validate();
        }
    }

    public void startLifeCycle() {
        this.initAllExtension();
        this.initModelAllExtension(this.model);
        this.initXMLAllExtension(this.model.getSession(), this.model.getOptionsParam());
        this.initViewAllExtension(this.view);
        this.hookAllExtension();
        this.startAllExtension();
    }

    public void stopAllExtension() {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            this.getExtension(i).stop();
        }
    }

    public void sessionChangedAllPlugin(Session session) {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            ExtensionHook extensionHook = (ExtensionHook)this.hookList.get(i);
            Vector vector = extensionHook.getSessionListenerList();
            for (int j = 0; j < vector.size(); ++j) {
                try {
                    SessionListener sessionListener = (SessionListener)vector.get(j);
                    if (sessionListener == null) continue;
                    sessionListener.sessionChanged(session);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void optionsChangedAllPlugin(OptionsParam optionsParam) {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            ExtensionHook extensionHook = (ExtensionHook)this.hookList.get(i);
            Vector vector = extensionHook.getOptionsListenerList();
            for (int j = 0; j < vector.size(); ++j) {
                try {
                    OptionsListener optionsListener = (OptionsListener)vector.get(j);
                    if (optionsListener == null) continue;
                    optionsListener.OptionsChanged(optionsParam);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void hookProxyListener(Proxy proxy) {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            ExtensionHook extensionHook = (ExtensionHook)this.hookList.get(i);
            Vector vector = extensionHook.getProxyListenerList();
            for (int j = 0; j < vector.size(); ++j) {
                try {
                    ProxyListener proxyListener = (ProxyListener)vector.get(j);
                    if (proxyListener == null) continue;
                    proxy.addProxyListener(proxyListener);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

