/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.HttpPanel;

public class LogPanel
extends AbstractPanel {
    private JScrollPane scrollLog = null;
    private JList listLog = null;
    private HttpPanel requestPanel = null;
    private HttpPanel responsePanel = null;

    public LogPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(600, 200);
        this.add((Component)this.getScrollLog(), "Center");
    }

    private JScrollPane getScrollLog() {
        if (this.scrollLog == null) {
            this.scrollLog = new JScrollPane();
            this.scrollLog.setViewportView(this.getListLog());
            this.scrollLog.setHorizontalScrollBarPolicy(31);
            this.scrollLog.setVerticalScrollBarPolicy(22);
            this.scrollLog.setPreferredSize(new Dimension(800, 200));
            this.scrollLog.setName("scrollLog");
        }
        return this.scrollLog;
    }

    public JList getListLog() {
        if (this.listLog == null) {
            this.listLog = new JList();
            this.listLog.setSelectionMode(0);
            this.listLog.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    HistoryReference historyReference = (HistoryReference)LogPanel.this.listLog.getSelectedValue();
                    HttpMessage httpMessage = null;
                    try {
                        httpMessage = historyReference.getHttpMessage();
                        if (httpMessage.getRequestHeader().isEmpty()) {
                            LogPanel.this.requestPanel.setMessage(null, true);
                        } else {
                            LogPanel.this.requestPanel.setMessage(httpMessage, true);
                        }
                        if (httpMessage.getResponseHeader().isEmpty()) {
                            LogPanel.this.responsePanel.setMessage(null, false);
                        } else {
                            LogPanel.this.responsePanel.setMessage(httpMessage, false);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
        return this.listLog;
    }

    public void setDisplayPanel(HttpPanel httpPanel, HttpPanel httpPanel2) {
        this.requestPanel = httpPanel;
        this.responsePanel = httpPanel2;
    }
}

