/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.util.regex.Pattern;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.model.HistoryList;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpHeader;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpStatusCode;

public class ProxyListenerLog
implements ProxyListener {
    private ViewDelegate view = null;
    private Model model = null;
    private HistoryList historyList = null;
    private Pattern pattern = null;

    public ProxyListenerLog(Model model, ViewDelegate viewDelegate, HistoryList historyList) {
        this.model = model;
        this.view = viewDelegate;
        this.historyList = historyList;
    }

    public void setFilter(String string) {
        this.pattern = string == null || string.equals("") ? null : Pattern.compile(string, 10);
    }

    public void onHttpRequestSend(HttpMessage httpMessage) {
        if (httpMessage.getRequestHeader().isImage()) {
            return;
        }
        this.view.getSiteTreePanel().expandRoot();
        HttpMessage httpMessage2 = this.model.getSession().getSiteTree().pollPath(httpMessage);
        if (httpMessage2 != null && !httpMessage2.getResponseHeader().isEmpty() && HttpStatusCode.isSuccess(httpMessage2.getResponseHeader().getStatusCode())) {
            return;
        }
        if (httpMessage.getRequestHeader().getHeader("If-Modified-Since") != null) {
            httpMessage.getRequestHeader().setHeader("If-Modified-Since", null);
        }
        if (httpMessage.getRequestHeader().getHeader("If-None-Match") != null) {
            httpMessage.getRequestHeader().setHeader("If-None-Match", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHttpResponseReceive(HttpMessage httpMessage) {
        if (this.isSkipImage(httpMessage.getRequestHeader()) || this.isSkipImage(httpMessage.getResponseHeader())) {
            return;
        }
        HistoryReference historyReference = null;
        try {
            historyReference = new HistoryReference(this.model.getSession(), 1, httpMessage);
        }
        catch (Exception exception) {
            return;
        }
        HistoryList historyList = this.historyList;
        synchronized (historyList) {
            if (this.pattern == null) {
                this.historyList.addElement(historyReference);
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(httpMessage.getRequestHeader().toString());
                stringBuffer.append(httpMessage.getRequestBody().toString());
                if (!httpMessage.getResponseHeader().isEmpty()) {
                    stringBuffer.append(httpMessage.getResponseHeader().toString());
                    stringBuffer.append(httpMessage.getResponseBody().toString());
                }
                if (this.pattern.matcher(stringBuffer.toString()).find()) {
                    this.historyList.addElement(historyReference);
                }
            }
        }
        this.model.getSession().getSiteTree().addPath(historyReference);
    }

    public boolean isSkipImage(HttpHeader httpHeader) {
        return httpHeader.isImage() && !this.model.getOptionsParam().getViewParam().isProcessImages();
    }
}

