/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.model;

import java.sql.SQLException;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;

public class HistoryReference {
    public static final int TYPE_TEMPORARY = 0;
    public static final int TYPE_MANUAL = 1;
    public static final int TYPE_SPIDER = 2;
    public static final int TYPE_SCANNER = 3;
    public static final int TYPE_SPIDER_UNSAVE = -2;
    private int historyId = 0;
    private int historyType = 1;
    private String display = "";
    private static TableHistory staticTableHistory = null;

    public HistoryReference(int n) throws HttpMalformedHeaderException, SQLException {
        RecordHistory recordHistory = null;
        recordHistory = staticTableHistory.read(n);
        this.build(recordHistory.getHistoryId(), recordHistory.getHistoryType(), recordHistory.getHttpMessage());
    }

    public HistoryReference(Session session, int n, HttpMessage httpMessage) throws HttpMalformedHeaderException, SQLException {
        RecordHistory recordHistory = null;
        recordHistory = staticTableHistory.write(session.getSessionId(), n, httpMessage);
        this.build(recordHistory.getHistoryId(), recordHistory.getHistoryType(), httpMessage);
    }

    private void build(int n, int n2, HttpMessage httpMessage) {
        StringBuffer stringBuffer = new StringBuffer(Integer.toString(n) + " ");
        stringBuffer.append(httpMessage.getRequestHeader().getPrimeHeader());
        if (!httpMessage.getResponseHeader().isEmpty()) {
            stringBuffer.append("  =>  " + httpMessage.getResponseHeader().getPrimeHeader());
        }
        this.display = stringBuffer.toString();
        this.historyId = n;
        this.historyType = n2;
    }

    public static void setTableHistory(TableHistory tableHistory) {
        staticTableHistory = tableHistory;
    }

    public int getHistoryId() {
        return this.historyId;
    }

    public HttpMessage getHttpMessage() throws HttpMalformedHeaderException, SQLException {
        RecordHistory recordHistory = staticTableHistory.read(this.historyId);
        return recordHistory.getHttpMessage();
    }

    public String toString() {
        return this.display;
    }

    public int getHistoryType() {
        return this.historyType;
    }
}

