/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HostAuthentication;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpMethodHelper;
import org.parosproxy.paros.network.HttpResponseHeader;

public class HttpSender {
    private static HttpMethodHelper helper;
    private static String userAgent;
    private HttpClient client = null;
    private HttpClient clientViaProxy = null;
    private ConnectionParam param = null;
    MultiThreadedHttpConnectionManager httpConnManager = null;
    MultiThreadedHttpConnectionManager httpConnManagerProxy = null;
    private boolean followRedirect = false;

    public HttpSender(ConnectionParam connectionParam) {
        this.param = connectionParam;
        this.client = this.createHttpClient();
        this.clientViaProxy = this.createHttpClientViaProxy();
        this.addAuth(this.client);
        this.addAuth(this.clientViaProxy);
    }

    private HttpClient createHttpClient() {
        this.httpConnManager = new MultiThreadedHttpConnectionManager();
        return new HttpClient(this.httpConnManager);
    }

    private HttpClient createHttpClientViaProxy() {
        if (this.param.getProxyChainName().equals("")) {
            return this.createHttpClient();
        }
        this.httpConnManagerProxy = new MultiThreadedHttpConnectionManager();
        HttpClient httpClient = new HttpClient(this.httpConnManagerProxy);
        httpClient.getHostConfiguration().setProxy(this.param.getProxyChainName(), this.param.getProxyChainPort());
        if (!this.param.getProxyChainUserName().equals("")) {
            UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(this.param.getProxyChainUserName(), this.param.getProxyChainPassword());
            AuthScope authScope = new AuthScope(this.param.getProxyChainName(), this.param.getProxyChainPort(), this.param.getProxyChainRealm().equals("") ? AuthScope.ANY_REALM : this.param.getProxyChainRealm());
            httpClient.getState().setProxyCredentials(authScope, usernamePasswordCredentials);
        }
        return httpClient;
    }

    public int executeMethod(HttpMethod httpMethod) throws HttpException, IOException {
        String string = httpMethod.getURI().getHost();
        httpMethod.setDoAuthentication(true);
        if (this.param.isUseProxy(string)) {
            return this.clientViaProxy.executeMethod(httpMethod);
        }
        return this.client.executeMethod(httpMethod);
    }

    public void shutdown() {
        if (this.httpConnManager != null) {
            this.httpConnManager.shutdown();
        }
        if (this.httpConnManagerProxy != null) {
            this.httpConnManagerProxy.shutdown();
        }
    }

    private void addAuth(HttpClient httpClient) {
        Vector vector = this.param.getListAuth();
        for (int i = 0; i < vector.size(); ++i) {
            HostAuthentication hostAuthentication = (HostAuthentication)vector.get(i);
            AuthScope authScope = new AuthScope(hostAuthentication.getHostName(), hostAuthentication.getPort(), hostAuthentication.getRealm().equals("") ? AuthScope.ANY_REALM : hostAuthentication.getRealm());
            NTCredentials nTCredentials = null;
            try {
                nTCredentials = new NTCredentials(hostAuthentication.getUserName(), hostAuthentication.getPassword(), InetAddress.getLocalHost().getCanonicalHostName(), hostAuthentication.getHostName());
                httpClient.getState().setCredentials(authScope, nTCredentials);
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                unknownHostException.printStackTrace();
            }
        }
    }

    public void sendAndReceive(HttpMessage httpMessage) throws HttpException, IOException {
        this.sendAndReceive(httpMessage, this.followRedirect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAndReceive(HttpMessage httpMessage, boolean bl) throws HttpException, IOException {
        HttpMethod httpMethod = null;
        HttpResponseHeader httpResponseHeader = null;
        try {
            httpMethod = this.send(httpMessage, bl);
            httpResponseHeader = HttpMethodHelper.getHttpResponseHeader(httpMethod);
            httpResponseHeader.setHeader("Transfer-encoding", null);
            httpMessage.setResponseHeader(httpResponseHeader);
            httpMessage.getResponseBody().setLength(0);
            httpMessage.getResponseBody().append(httpMethod.getResponseBody());
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
    }

    private HttpMethod send(HttpMessage httpMessage, boolean bl) throws HttpException, IOException {
        int n = -1;
        HttpMethod httpMethod = null;
        this.modifyUserAgent(httpMessage);
        httpMethod = helper.createRequestMethod(httpMessage.getRequestHeader(), httpMessage.getRequestBody());
        httpMethod.setFollowRedirects(bl);
        n = this.executeMethod(httpMethod);
        return httpMethod;
    }

    public void setFollowRedirect(boolean bl) {
        this.followRedirect = bl;
    }

    private void modifyUserAgent(HttpMessage httpMessage) {
        try {
            if (userAgent.equals("") || httpMessage.getRequestHeader().isEmpty()) {
                return;
            }
            String string = httpMessage.getRequestHeader().getHeader("User-Agent");
            if (string == null) {
                string = "";
            }
            String string2 = "";
            if (!string.equals("") && !string.endsWith(" ")) {
                string2 = " ";
            }
            string = string + string2 + userAgent;
            httpMessage.getRequestHeader().setHeader("User-Agent", string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getUserAgent() {
        return userAgent;
    }

    public static void setUserAgent(String string) {
        userAgent = string;
    }

    static {
        HttpConnectionManagerParams.MAX_HOST_CONNECTIONS = "5";
        helper = new HttpMethodHelper();
        userAgent = "";
    }
}

