package fx.Cps;
/*
* Copyright Hewlett-Packard Company 1997 All rights reserved
* This file may be copied, modified and distributed only in
* accordance with the terms of the limited licence contained
* in the accompanying file LICENSE.
*/

import hp.chaiserver.*;
import java.io.*;

public final class CpsStub extends Worker implements IWorker {

	private final String DISCOVERPROPS = new String("__DISCOVERPROPS");
	public final String WORKER_VERSION = "ChaiServer.3.0.0.0";
	private final static String SCANHOST	= new String("ScanHost");
	private final static String KILLSCAN	= new String("KillScan");
	private final static String ABOUTPAGE	= new String("aboutPage");

	// Helper methods for worker
	protected Object createObject() {
		return (Object) new CpsImpl();
	}

	protected String getObjectClassName() {
		return new String("CpsImpl");
	}

	protected boolean invokeMethod(Object obj, String method, String format)
		throws Exception {
		CpsImpl cs_obj = (CpsImpl) obj;

		if(method.equalsIgnoreCase(DISCOVERPROPS)) {
			webProtocol.sendToClient("HTTP/1.1 200 OK\r\n");
			webProtocol.sendToClient("MIME-Version: 1.0\r\n");
			webProtocol.sendToClient("Server: HP/ChaiServer 3.0\r\n");
			webProtocol.sendToClient("Content-type: text/plain\r\n\n");
			webProtocol.sendToClient("ScanHost,KillScan,aboutPage");
			return true;
		}
		if (method.equalsIgnoreCase(SCANHOST))
			cs_obj.ScanHost(format, args, reqEnv);

		else if (method.equalsIgnoreCase(KILLSCAN))
			cs_obj.KillScan(format, args, reqEnv);

		else if (method.equalsIgnoreCase(ABOUTPAGE))
			cs_obj.aboutPage(format, args, reqEnv);
		else
			return false;

		return true;
	}

	protected boolean isObjectInstance(Object obj) {
		return (obj instanceof CpsImpl);
	}

	// Methods callable outside of worker
	public String getVersion() {
		return WORKER_VERSION;
	}

}

