/* $Id: scanPort.java,v 1.8 2002/04/29 17:49:52 fx Exp fx $ */
package fx.Cps;

import java.io.*;
import java.net.*;

public class scanPort extends Thread {
    private Thread	killer;
    private InetAddress	l_target;
    private int		l_port;
    private String	l_filename;
    private boolean	open_p;
    private Socket	s;

    /* 
     * Constructor
     *
     */
    scanPort(InetAddress target, int port, String filename) {
	this.l_target=target;
	this.l_port=port;
	this.l_filename=filename;
	this.s=null;
	this.open_p=false;

    }

    public void run() {

	this.s=null;
	this.open_p=false;

	try {
	    this.s = new Socket(l_target,l_port);
	    this.open_p=true;
	} catch (SocketException e) { 
	    this.open_p=false;
	    this.suicide(); 
	} catch (IOException e) {
	    this.open_p=false;
	    this.suicide(); 
	} catch (Throwable e) {
	    this.open_p=false;
	    this.suicide(); 
	}

	try {
	    this.s.setSoTimeout(1000);
	    OutputStream out = this.s.getOutputStream();
	    out.write(42);
	    //PrintStream pout = new PrintStream( out );
	    //pout.println("Hello!");
	} catch (IOException e) {
	    this.open_p=false;
	    this.suicide();
	}


	if ((this.s!=null)&&(this.open_p==true)) {
	    logport();
	}

	try {
	    if (this.s != null) {
		this.s.close();
	    }
	} catch (SocketException e) {
	    // ignore
	} catch (IOException e) {
	    // ignore
	}

	stop();
    }

    public void suicide() {
	//System.out.println("scanPort.suicide() called");
	stop();
    }

    public void logport() {
	try {
	    FileOutputStream 	fo = new FileOutputStream(l_filename,true);
	    String		s = this.l_port+" open\n";

	    /* FIXME: This is definetly NOT very Java'ish but
	     * I cant help it right now. */
	    byte[]		b = new byte[s.length()];

	    for (int i=0; i<s.length(); i++) {
		b[i]=(byte)s.charAt(i);
	    }

	    fo.write(b);
	    fo.close();
	} catch (IOException e) {
	    // do nothing about it
	}
    }

}
