// D_FS.cpp : implementation file
//

#include "stdafx.h"
#include "PFT.h"
#include "D_FS.h"
#include "direct.h"
#include "D_DIRNAME.h"

#include "commands.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CD_FS dialog


CD_FS::CD_FS(CWnd* pParent /*=NULL*/)
	: CDialog(CD_FS::IDD, pParent)
{
	//{{AFX_DATA_INIT(CD_FS)
	//}}AFX_DATA_INIT
	
	B_PH.LoadBitmaps(_T(IDB_BI_FS_PH_N),_T(IDB_BI_FS_PH_C),_T(IDB_BI_FS_PH_F),_T(IDB_BI_FS_PH_D));
	B_HP.LoadBitmaps(_T(IDB_BI_FS_HP_N),_T(IDB_BI_FS_HP_C),_T(IDB_BI_FS_HP_F),_T(IDB_BI_FS_HP_D));
    B_OK.LoadBitmaps(_T(IDB_BI_FSOK_N),_T(IDB_BI_FSOK_C),_T(IDB_BI_FSOK_F),_T(IDB_BI_FSOK_D));
	B_MD.LoadBitmaps(_T(IDB_BI_FSMD_N),_T(IDB_BI_FSMD_C),_T(IDB_BI_FSMD_F),_T(IDB_BI_FSMD_D));
	B_RD.LoadBitmaps(_T(IDB_BI_FSRD_N),_T(IDB_BI_FSRD_C),_T(IDB_BI_FSRD_F),_T(IDB_BI_FSRD_D));

	PFTses = &(((CPFTApp *)AfxGetApp())->GlobPFTSes);
	
} 


void CD_FS::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CD_FS)
	DDX_Control(pDX, IDC_TBPInfo, m_TBPInfo);
	DDX_Control(pDX, IDC_TBHInfo, m_TBHInfo);
	DDX_Control(pDX, IDC_CO_PVol, m_CO_PVol);
	DDX_Control(pDX, IDC_CO_HVol, m_CO_HVol);
	DDX_Control(pDX, IDC_LC_HFileS, m_LB_HFiles);
	DDX_Control(pDX, IDC_LC_PFileS, m_LB_PFiles);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CD_FS, CDialog)
	//{{AFX_MSG_MAP(CD_FS)
	ON_BN_CLICKED(IDC_B_PH, OnBPh)
	ON_WM_DESTROY()
	ON_NOTIFY(NM_DBLCLK, IDC_LC_HFileS, OnDblclkLCHFileS)
	ON_CBN_SELCHANGE(IDC_CO_HVol, OnSelchangeCOHVol)
	ON_BN_CLICKED(IDC_B_OK, OnBOk)
	ON_CBN_SELCHANGE(IDC_CO_PVol, OnSelchangeCOPVol)
	ON_NOTIFY(NM_DBLCLK, IDC_LC_PFileS, OnDblclkLCPFileS)
	ON_BN_CLICKED(IDC_B_MD, OnBMd)
	ON_BN_CLICKED(IDC_B_RD, OnBRd)
	ON_BN_CLICKED(IDC_B_HP, OnBHp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CD_FS message handlers

BOOL CD_FS::OnInitDialog() 
{
	CDialog::OnInitDialog();	
	// TODO: Add extra initialization here
	VERIFY(B_PH.SubclassDlgItem(IDC_B_PH, this));
	B_PH.SizeToContent();
	VERIFY(B_HP.SubclassDlgItem(IDC_B_HP, this));
	B_HP.SizeToContent();
	VERIFY(B_OK.SubclassDlgItem(IDC_B_OK, this));
	B_OK.SizeToContent();
    VERIFY(B_MD.SubclassDlgItem(IDC_B_MD, this));
	B_MD.SizeToContent();
 	VERIFY(B_RD.SubclassDlgItem(IDC_B_RD, this));
	B_RD.SizeToContent();
 
    //fill listboxen
    //local drives
	DWORD drives = GetLogicalDrives();
    char drv[3];
	drv[2]='\0';
    int curdrv = 0;
	curdrv = _getdrive();
    
	for ( int i  = 0 ;i< 26;i++){
		if (( drives >> i ) & 1){
            _snprintf( drv,2,"%c:",(char) i+'A');  
			m_CO_HVol.AddString(drv);

			if (curdrv == i+1){
				m_CO_HVol.SetCurSel(m_CO_HVol.GetCount()-1);
			}
		}
	}

    //curent dir
	CPFTApp *app;
	app = (CPFTApp *)AfxGetApp();
    m_LB_HFiles.InsertColumn( 1,"d",LVCFMT_LEFT,200,-1);
	m_LB_HFiles.SetColumnWidth(0,88);

	
    CImageList *il;
	il = new CImageList;		
	il->Create(16, 16, TRUE,  4, 4);
	il->Add(app->LoadIcon(IDI_FOLDER));
	il->Add(app->LoadIcon(IDI_FILE));
	m_LB_HFiles.SetImageList(il,LVSIL_SMALL);

	//local files 
	char dir[201];
	dir[200] = '\0';
    _getcwd(dir,199);
    mf_FSH_AddDir((CString) dir);

	//Printer Volumes
	m_LB_PFiles.InsertColumn( 1,"d",LVCFMT_LEFT,200,-1);
	m_LB_PFiles.SetColumnWidth(0,88);
	m_LB_PFiles.SetImageList(il,LVSIL_SMALL);
    for (unsigned int k=0;k<PFTses->vol.count();k++) {
		m_CO_PVol.AddString(PFTses->vol.element(k)->get_volume()->get());
	}//for (unsigned int k=0;i<PFTses.vol.count();k++)
    m_CO_PVol.SetCurSel(0);

    mf_FSP_AddDir(PFTses->vol.element((unsigned int)0)->get_volume()->get());
    CString Buff;
	Buff="Location: ";
	Buff+=PFTses->vol.element((unsigned int)0)->get_location()->get();
	Buff+="\nSize: ";
	Buff+=PFTses->vol.element((unsigned int)0)->get_size()->get();
	Buff+="\nFree: ";
	Buff+=PFTses->vol.element((unsigned int)0)->get_free()->get();
	
	m_TBPInfo.SetWindowText(Buff);
	
	this->SetWindowText(Conto);	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}



void CD_FS::OnDestroy() 
{
	CDialog::OnDestroy();
	
	mf_FSH_RmItems();
	mf_FSP_RmItems();

	// TODO: Add your message handler code here
	
}


void CD_FS::mf_FSH_AddDir(CString CS_Dir)
{
	mf_FSH_RmItems();
	CD_FS::RedrawWindow(NULL,NULL,RDW_UPDATENOW);

	CFileFind	finder;
	CS_Dir+="\\*.*";
	BOOL bWorking = finder.FindFile(CS_Dir);
	int i,felix_index=-1 ;
	
	i=0;


 	while (bWorking) {
  	    
		bWorking= finder.FindNextFile();

	
        SFILE *pSfile = new SFILE;
        pSfile->name=finder.GetFileName();
	    pSfile->fullpath=finder.GetFilePath();
        
		if ( finder.IsDirectory() ){
			felix_index=m_LB_HFiles.InsertItem(i,pSfile->name ,0);
			pSfile->dir=1;
		}else{
			felix_index=m_LB_HFiles.InsertItem(i,pSfile->name,1);
			pSfile->dir=0;
		}

		if (felix_index>(-1)) {		
			m_LB_HFiles.SetItemData( felix_index,(DWORD) pSfile);
		}

        
       	i++;
	} 

	 m_LB_HFiles.SortItems(SortSFileItems,(LPARAM) &m_LB_HFiles);

}



void CD_FS::mf_FSH_RmIlist()
{
		CImageList *p = 0;
	p = m_LB_HFiles.GetImageList (LVSIL_SMALL);
	delete p;
    

}

void CD_FS::mf_FSH_RmItems()
{
	SFILE *s = 0;
	SFILE G;
	for (int i= m_LB_HFiles.GetItemCount();i>0;i--){
         s = ((SFILE *) m_LB_HFiles.GetItemData(i-1));
	   	 delete s;
		 m_LB_HFiles.DeleteItem(i-1);
	}

	return;

}

///////////////////////////////////////

void CD_FS::mf_FSP_AddDir(CString CS_Dir)
{

	mf_FSP_RmItems();
	CD_FS::RedrawWindow(NULL,NULL,RDW_UPDATENOW);
    int k;	

	
	k=CS_Dir.Find("\\..");
	
	if (k > 0){
		CS_Dir=CS_Dir.Left(k) ;
		k=CS_Dir.Find("\\");
		CS_Dir=CS_Dir.Left(k) ;
	}
	CS_Dir+="\\";
    PFTses->read_dir((char*) CS_Dir.GetBuffer(1));
	

	unsigned int i;
	int felix_index=-1 ;
	
	i=0;


	for ( i=0;i< PFTses->dir.count();i++){

	
        SFILE *pSfile = new SFILE;
        pSfile->name=PFTses->dir.element(i)->get_name()->get();
	    pSfile->fullpath=CS_Dir + PFTses->dir.element(i)->get_name()->get();
        
		if ( PFTses->dir.element(i)->get_type() == PJLFS_DIR ){
			felix_index=m_LB_PFiles.InsertItem(i,pSfile->name ,0);
			pSfile->dir=1;
		}else{
			felix_index=m_LB_PFiles.InsertItem(i,pSfile->name,1);
			pSfile->dir=0;
		}

		if (felix_index>(-1)) {		
			m_LB_PFiles.SetItemData( felix_index,(DWORD) pSfile);
		}

	} //for

	 m_LB_PFiles.SortItems(SortSFileItems,(LPARAM) &m_LB_PFiles);

}



void CD_FS::mf_FSP_RmIlist()
{
		CImageList *p = 0;
	p = m_LB_PFiles.GetImageList (LVSIL_SMALL);
	delete p;


}

void CD_FS::mf_FSP_RmItems()
{
	SFILE *s = 0;

	for (int i= m_LB_PFiles.GetItemCount();i>0;i--){
         s = ((SFILE *) m_LB_PFiles.GetItemData(i-1));
	   	 delete s;
		 m_LB_PFiles.DeleteItem(i-1);
	}

	return;

}

/////////////////////////////////////
static int CALLBACK SortSFileItems(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	SFILE *p1 ,*p2;
	p1 =((SFILE *)lParam1);
	p2 =((SFILE *)lParam2);

	    
    if ( p1->dir == p2->dir){
		return strcmp( p1->name ,p2->name);
	}
    if (p1->dir){
		return 0;
	}else {
		return 1;
		}
}


void CD_FS::OnDblclkLCHFileS(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	BeginWaitCursor();
	if (m_LB_HFiles.GetSelectedCount() !=0){
			if ( ((SFILE *) m_LB_HFiles.GetItemData( m_LB_HFiles.GetSelectionMark()))->dir  )  {
				mf_FSH_AddDir(((SFILE *) m_LB_HFiles.GetItemData( m_LB_HFiles.GetSelectionMark()))->fullpath);
			}
	*pResult = 0;
	}
	
}


void CD_FS::OnSelchangeCOHVol() 
{
	// TODO: Add your control notification handler code here
	   BeginWaitCursor();
      CString S_Vol;
	   m_CO_HVol.GetLBText(m_CO_HVol.GetCurSel(),S_Vol);
	   if (!_chdrive( S_Vol[0]-64)){
             mf_FSH_AddDir(S_Vol);
	   }else {
		   AfxMessageBox("Unable to read from Drive");
	   }
		

}

void CD_FS::OnBOk() 
{
	// TODO: Add your control notification handler code here
	CD_FS::OnOK ();
}


void CD_FS::OnSelchangeCOPVol() 
{
	   // TODO: Add your control notification handler code here
	   BeginWaitCursor();
	   CString S_Vol;
	   m_CO_PVol.GetLBText(m_CO_PVol.GetCurSel(),S_Vol);
       mf_FSP_AddDir(S_Vol);	

	   CString Buff;
	   Buff="Location: ";
	   Buff+=PFTses->vol.element(m_CO_PVol.GetCurSel())->get_location()->get();
	   Buff+="\nSize: ";
	   Buff+=PFTses->vol.element(m_CO_PVol.GetCurSel())->get_size()->get();
	   Buff+="\nFree: ";
	   Buff+=PFTses->vol.element(m_CO_PVol.GetCurSel())->get_free()->get();
	   m_TBPInfo.SetWindowText(Buff);
		
}

void CD_FS::OnDblclkLCPFileS(NMHDR* pNMHDR, LRESULT* pResult) 
{
	BeginWaitCursor();
	// TODO: Add your control notification handler code here
    if (m_LB_PFiles.GetSelectedCount()!=0){
     if ( ((SFILE *) m_LB_PFiles.GetItemData( m_LB_PFiles.GetSelectionMark()))->dir  )  {
	    mf_FSP_AddDir(((SFILE *) m_LB_PFiles.GetItemData( m_LB_PFiles.GetSelectionMark()))->fullpath);
	
	 }
	}
	*pResult = 0;
	
}

void CD_FS::OnBMd() 
{
	BeginWaitCursor();
    CString DIRNAME;
	CString buff;

	CD_DIRNAME dlg;

	int I; 
	I=dlg.DoModal();
	if  (I==IDOK ) {  // My Graphical OK Button 
	
		DIRNAME=((SFILE *) m_LB_PFiles.GetItemData(0))->fullpath;
		DIRNAME=DIRNAME.Left(DIRNAME.ReverseFind('\\')+1);
		DIRNAME+= dlg.m_V_NAME;
	

		//AfxMessageBox(DIRNAME);
		try{
			PFTses->create_dir(DIRNAME.GetBuffer(1));
		    //reread DIR
			DIRNAME=((SFILE *) m_LB_PFiles.GetItemData(0))->fullpath;
			DIRNAME=DIRNAME.Left(DIRNAME.ReverseFind('\\'));   
			mf_FSP_AddDir(DIRNAME); 	
		}
		catch(...){
			AfxMessageBox("Not DONE");
		}
	
	}
	
}


void CD_FS::OnBRd() 
{
	// TODO: Add your control notification handler code here
	BeginWaitCursor();
	CString DIRNAME;
	if ( m_LB_PFiles.GetSelectedCount()==0){
	   AfxMessageBox("N");
	return;
	}

	try {
	  PFTses->delete_file(
		  (((SFILE *) m_LB_PFiles.GetItemData( m_LB_PFiles.GetSelectionMark() ) )->fullpath).GetBuffer(1)
		  );
	}
	catch(...){
	  AfxMessageBox("Not DONE");
	}
	
	DIRNAME=((SFILE *) m_LB_PFiles.GetItemData(0))->fullpath;
	DIRNAME=DIRNAME.Left(DIRNAME.ReverseFind('\\'));   
	mf_FSP_AddDir(DIRNAME); 	
	
}


void CD_FS::OnBHp() 
{
	// TODO: Add your control notification handler code here
	BeginWaitCursor();
	CString DIRNAME;

	if ( m_LB_HFiles.GetSelectedCount()==0){
	   AfxMessageBox("Nothing selected ??");
	return;
	}
    if  ( ((SFILE *) m_LB_HFiles.GetItemData( m_LB_HFiles.GetSelectionMark() ) )->dir){
	    AfxMessageBox("We do coppy only single Files :( ");
		return;
	}	
	
    


	if (m_LB_PFiles.GetItemCount() >0){
			DIRNAME=((SFILE *) m_LB_PFiles.GetItemData(0))->fullpath;
			DIRNAME=DIRNAME.Left(DIRNAME.ReverseFind('\\')+1);
			DIRNAME+=((SFILE *) m_LB_HFiles.GetItemData(m_LB_HFiles.GetSelectionMark()))->name;
	}else{
	        m_CO_HVol.GetLBText(m_CO_PVol.GetCurSel(),DIRNAME);
		    DIRNAME+="\\"+((SFILE *) m_LB_PFiles.GetItemData(m_LB_PFiles.GetSelectionMark()))->name;
			
	}
	try {
			PFTses->send_file(DIRNAME.GetBuffer(1),(((SFILE *) m_LB_HFiles.GetItemData(m_LB_HFiles.GetSelectionMark()))->fullpath).GetBuffer(1));
	
			// reread DIR
			if (m_LB_PFiles.GetItemCount() >0){
			   DIRNAME=((SFILE *) m_LB_PFiles.GetItemData(0))->fullpath;
			   DIRNAME=DIRNAME.Left(DIRNAME.ReverseFind('\\'));   
			}else {
		        m_CO_HVol.GetLBText(m_CO_PVol.GetCurSel(),DIRNAME);
			}

	       mf_FSP_AddDir(DIRNAME); 	
	
	
	} catch (...) {
				AfxMessageBox("sorry" );		
	}

	

}

void CD_FS::OnBPh() 

{
	// File from printer to local drive
	// TODO: Add your control notification handler code here
	BeginWaitCursor();
	PJLfilePrim		*e;
	CString DIRNAME;
	CString f;
	
	if ( m_LB_PFiles.GetSelectedCount()==0){
	   AfxMessageBox("Nothing selected ??");
	return;
	}

	if  ( ((SFILE *) m_LB_PFiles.GetItemData( m_LB_PFiles.GetSelectionMark() ) )->dir){
	    AfxMessageBox("We do coppy only single Files :( ");
		return;
	}
	
		e=PFTses->dir.element((((SFILE *) m_LB_PFiles.GetItemData(m_LB_PFiles.GetSelectionMark()))->name).GetBuffer(1));
        
        
		if (m_LB_HFiles.GetItemCount() >0){
			DIRNAME=((SFILE *) m_LB_HFiles.GetItemData(0))->fullpath;
			DIRNAME=DIRNAME.Left(DIRNAME.ReverseFind('\\')+1);
			DIRNAME+=((SFILE *) m_LB_PFiles.GetItemData(m_LB_PFiles.GetSelectionMark()))->name;
		}else{
	        m_CO_HVol.GetLBText(m_CO_HVol.GetCurSel(),DIRNAME);
		    DIRNAME+="\\"+((SFILE *) m_LB_PFiles.GetItemData(m_LB_PFiles.GetSelectionMark()))->name;
		}

		
		try {
		   PFTses->recv_file((((SFILE *) m_LB_PFiles.GetItemData(m_LB_PFiles.GetSelectionMark()))->fullpath).GetBuffer(1),e->get_size(),DIRNAME.GetBuffer(1));

			// reread DIR 
		   	if (m_LB_HFiles.GetItemCount() >0){
			   DIRNAME=((SFILE *) m_LB_HFiles.GetItemData(0))->fullpath;
			   DIRNAME=DIRNAME.Left(DIRNAME.ReverseFind('\\'));   
			}else {
		        m_CO_HVol.GetLBText(m_CO_HVol.GetCurSel(),DIRNAME);

			}

	       mf_FSH_AddDir(DIRNAME); 	
	
		}
		catch(...){
		  AfxMessageBox("Sorry not possible");
		}
	

	

}
