// PFTDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PFT.h"
#include "PFTDlg.h"
#include "D_FS.h"
#include "D_ENV.h"
#include "D_DIS.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CBitmapButton B_OK;
	CAboutDlg();
	void CAboutDlg::DoDataExchange(CDataExchange* pDX);
// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnBOk();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	ON_BN_CLICKED(IDC_B_OK, OnBOk)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	B_OK.LoadBitmaps(_T(IDB_BI_FSOK_N),_T(IDB_BI_FSOK_C),_T(IDB_BI_FSOK_F),_T(IDB_BI_FSOK_D));
	VERIFY(B_OK.SubclassDlgItem(IDC_B_OK, this));
	B_OK.SizeToContent();


	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CAboutDlg::OnBOk() 
{
	// TODO: Add your control notification handler code here
	CDialog::OnOK();
	
}





/////////////////////////////////////////////////////////////////////////////
// CPFTDlg dialog

CPFTDlg::CPFTDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPFTDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPFTDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	B_Env.LoadBitmaps(_T(IDB_BI_ENV_N),_T(IDB_BI_ENV_C),_T(IDB_BI_ENV_F),_T(IDB_BI_ENV_D));
	B_Fs.LoadBitmaps(_T(IDB_BI_FS_N),_T(IDB_BI_FS_C),_T(IDB_BI_FS_F),_T(IDB_BI_FS_D));
	B_Dsp.LoadBitmaps(_T(IDB_BI_DSP_N),_T(IDB_BI_DSP_C),_T(IDB_BI_DSP_F),_T(IDB_BI_DSP_D));
	B_Ex.LoadBitmaps(_T(IDB_BI_EX_N),_T(IDB_BI_EX_C),_T(IDB_BI_EX_F),_T(IDB_BI_EX_D));
	B_Con.LoadBitmaps(_T(IDB_BI_CON_N),_T(IDB_BI_CON_C),_T(IDB_BI_CON_F),_T(IDB_BI_CON_D));
	
	PFTses = &(((CPFTApp *)AfxGetApp())->GlobPFTSes);
    
}

void CPFTDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPFTDlg)
	DDX_Control(pDX, IDC_EPort, m_Eport);
	DDX_Control(pDX, IDC_ETarget, m_ETarget);
	DDX_Control(pDX, IDC_S_Port, m_SPort);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPFTDlg, CDialog)
	//{{AFX_MSG_MAP(CPFTDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDExit, OnExit)
	ON_BN_CLICKED(IDC_B_Fs, OnBFs)
	ON_BN_CLICKED(IDC_B_Ex, OnBEx)
	ON_BN_CLICKED(IDC_B_Con, OnBCon)
	ON_BN_CLICKED(IDC_B_Env, OnBEnv)
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_B_Dsp, OnBDsp)
	ON_BN_CLICKED(IDC_IM_MAIN, OnImMain)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPFTDlg message handlers

BOOL CPFTDlg::OnInitDialog()
{
	CDialog::OnInitDialog();


	// Add "About..." menu item to system menu.
	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
    

    VERIFY(B_Env.SubclassDlgItem(IDC_B_Env, this));
	B_Env.SizeToContent();
	
    VERIFY(B_Fs.SubclassDlgItem(IDC_B_Fs, this));
    B_Fs.SizeToContent();
   
    VERIFY(B_Dsp.SubclassDlgItem(IDC_B_Dsp, this));
	B_Dsp.SizeToContent();
    VERIFY(B_Ex.SubclassDlgItem(IDC_B_Ex, this));
	B_Ex.SizeToContent();
    VERIFY(B_Con.SubclassDlgItem(IDC_B_Con, this));
	B_Con.SizeToContent();
	
	m_SPort.SetRange32(0,65535);
	m_SPort.SetPos(9100);
    B_Con.SetFocus(); 
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPFTDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPFTDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPFTDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CPFTDlg::OnExit() 
{ 
   CPFTDlg::OnOK() ;  
	// TODO: Add your control notification handler code here
	
}


void CPFTDlg::OnBFs() 
{
	// TODO: Add your control notification handler code here
   BeginWaitCursor();
   CD_FS dlg;
   
   CString Text,buff1,buff2 ;
   m_ETarget.GetWindowText(buff1);
   m_Eport.GetWindowText(buff2);
   Text = PFTses->get_device_id()->get();
   Text += " on "+buff1+":"+buff2;
   dlg.Conto = Text;
   
   
   dlg.DoModal();

}



void CPFTDlg::OnBEx() 
{
	// TODO: Add your control notification handler code here
     CPFTDlg::OnOK() ;  
}

void CPFTDlg::OnBEnv() 
{
    // TODO: Add your control notification handler code here
    BeginWaitCursor();
	CD_ENV dlg;
	CString Text,buff1,buff2 ;
	m_ETarget.GetWindowText(buff1);
	m_Eport.GetWindowText(buff2);
	Text = PFTses->get_device_id()->get();
	Text += " on "+buff1+":"+buff2;
	dlg.Conto = Text;
   

	try {
      PFTses->read_env();
	}
	catch(...){
		AfxMessageBox("ERROR: Problem reading Environment");
	}

	dlg.DoModal();
	
}
void CPFTDlg::OnBCon() 
{
	
	// TODO: Add your control notification handler code here
    BeginWaitCursor();
	CString host, port;
   
	// make Button clicked ..
    B_Con.EnableWindow(FALSE);
	m_ETarget.GetWindowText(host); 
	m_Eport.GetWindowText(port);
	
	

	if (PFTses->connected()){
        m_discon();
		m_ETarget.EnableWindow(TRUE);
		m_Eport.EnableWindow(TRUE);
			
	}else{

	  // try to connect
	  try {
		PFTses->initiate(host.GetBuffer(1),atoi(port));;
		PFTses->write_ustatus("OFF");
		// test if con device is a printer
		PFTses->read_device_id();
		
	  } catch (TCPcon::ExSocket) {
		MessageBox("ERROR: Socket error ","Connect",MB_OK);
		m_discon();
	  } catch(TCPcon::ExResolver) {
		MessageBox("ERROR: Cant find host","Connect",MB_OK);
        m_discon();

	  } catch(PJLsession::ExPJLerror ){
		  MessageBox("ERROR: DEF ID ?","Connect",MB_OK);
		  m_discon();
	  }
	   catch(...)	{
		MessageBox("ERROR: Problem while connecting ","Connect",MB_OK);
		m_discon();
	  } //try
      
	   //success ?
		if (PFTses->connected()){
			 // Yep
			// change connect button
		    B_Con.LoadBitmaps(_T(IDB_BI_DCON_N),_T(IDB_BI_DCON_C),_T(IDB_BI_DCON_F),_T(IDB_BI_DCON_C));
			CPFTDlg::RedrawWindow(NULL,NULL,RDW_UPDATENOW);

			// disable port and IP Button  
            m_ETarget.EnableWindow(FALSE);
			m_Eport.EnableWindow(FALSE);
			//Volumes ??
			try {
 				PFTses->read_volumes();
                B_Env.EnableWindow(TRUE);
	    		B_Dsp.EnableWindow(TRUE);
			}catch(TCPcon::ExSocket){
				MessageBox("ERROR: Connection lost ","Connect",MB_OK);
				m_discon();
			}catch(...){}
			
            if (PFTses->vol.count()){
                B_Fs.EnableWindow(TRUE); 
			}
		
		}//if (PFTses->connected())
	
	}//else of if (PFTses->connected()) (before try 
    
	
	// Button change actualize
	CPFTDlg::RedrawWindow(NULL,NULL,RDW_UPDATENOW);
	B_Con.EnableWindow(TRUE);
	EndWaitCursor();


} 




void CPFTDlg::m_discon()
{
	//close con    
	PFTses->close();
	//set buttons
    B_Con.LoadBitmaps(_T(IDB_BI_CON_N),_T(IDB_BI_CON_C),_T(IDB_BI_CON_F),_T(IDB_BI_CON_D));
	CPFTDlg::RedrawWindow(NULL,NULL,RDW_UPDATENOW);
	B_Env.EnableWindow(FALSE);
	B_Dsp.EnableWindow(FALSE);
	B_Fs.EnableWindow(FALSE);		
}


void CPFTDlg::OnButton1() 
{
	// TODO: Add your control notification handler code here
    CPFTDlg::OnBCon();	
}



void CPFTDlg::OnBDsp() 
{
	// TODO: Add your control notification handler code here

	D_DIS dlg;
	CString Text,buff1,buff2 ;
	m_ETarget.GetWindowText(buff1);
	m_Eport.GetWindowText(buff2);
	Text = PFTses->get_device_id()->get();
	Text += " on "+buff1+":"+buff2;
	dlg.Conto = Text;
  
	dlg.DoModal();

}





void CPFTDlg::OnImMain() 
{
	// TODO: Add your control notification handler code here
	
}
