#
# Report subnets
#

# generate the tables for looking subnets/hosts in:
&make_subnet_info();
$_subnets = keys %all_subnets;

sub sort_ip {
    local($aip,$bip);
    for $ip (split(/\./,$a)) { $aip = $aip * 256 + $ip; }
    for $ip (split(/\./,$b)) { $bip = $bip * 256 + $ip; }
    return $aip <=> $bip;
}

print CLIENT <<EOF;
<HTML>
<HEAD>
<title> Host Tables - By Subnet  </title>
<LINK REV="made" HREF="mailto:saint\@wwdsi.com">
</HEAD>
<BODY BACKGROUND="$HTML_ROOT/images/bckgrnd.jpg" vlink="#000000" link="#04289D">
<TABLE border=0 width=100%>
 <TR>
 <TD width=10% valign=top>
   <a href="http://www.wwdsi.com"><img src="$HTML_ROOT/images/saint.gif"
    ALT="WWDSI" BORDER="0"></A><P>
   <LI><A HREF="$HTML_ROOT"/saint.html">
      <strong> SAINT Home </strong></A><P>
   <LI><A HREF="$HTML_SERVER/data/saint_data_form.pl">
      <strong> Data Management</strong></A><P>
   <LI><A HREF="$HTML_SERVER/running/saint_run_form.pl">
      <STRONG>Target selection</STRONG></A><p>
   <LI> <STRONG> Data Analysis</STRONG><p>

   <LI><A HREF="$HTML_SERVER/admin/saint_cf_form.pl">
     <strong>Configuration Mgt</strong></A><p>
   <LI><A HREF="$HTML_SERVER/saint_documentation.pl">
     <strong>Documentation</strong></A><p>
   <LI><A HREF="$HTML_SERVER/docs/FAQ.html#trouble">
     <strong>Troubleshooting</strong></A><P>
</TD><TD valign=top>
<CENTER><H1>Host Tables - By Subnet </H1></CENTER>
<hr><UL><UL>
<h3>$_subnets Subnets. Number of hosts per subnet (vulnerable/total). </h3>
<strong>Subnets with a red dot next to them have a vulnerable host contained within.</strong>
<ul>
EOF

# until the subnet is all looked at...
for $_net (sort sort_ip keys %all_subnets) {
    $dot = $subnet_severities{$_net} ? "red" : "black";
    print CLIENT <<EOF;
	    <dt><IMG SRC=$HTML_ROOT/dots/$dot\dot.gif ALT="$dot">
	    <a href="saint_results_subnet.pl,$_net,"> $_net </a> 
	    ($subnet_severities{$_net}/$subnet_count{$_net})
EOF
    }

print CLIENT <<EOF;
</ul>
<hr> <a href=$HTML_STARTPAGE> Back to the SAINT start page </a> |
<a href=analysis.pl> Back to SAINT Reporting and Analysis </a>
</UL></UL></TABLE>
</BODY>
</HTML>
EOF
