#
# Display a list of hosts sorted on some attribute; hosts may be member
# of more than group.
#

&make_severity_info();

$_sort_title = "";
%_sort_group = ();
$_sort_sub = "";
%_not_linked = ();
$_sort_note = "";
%printed = ();

#
# Factor out sort-order dependent code.
#

sub sort_alpha {
        $a cmp $b;
}

sub sort_severity {
	$_res = ($severity_host_count{$b} <=> $severity_host_count{$a});
	return ($_res != 0) ? $_res : $a cmp $b;
}

sub sort_ip {
	local($aip,$bip);
	for $ip (split(/\./,$a)) { $aip = $aip * 256 + $ip; }
	for $ip (split(/\./,$b)) { $bip = $bip * 256 + $ip; }
	return $aip <=> $bip;
}

$_sort_toc = "sort_alpha";

if ($_sort_order eq "" || $_sort_order eq "name") {
	$_sort_group{""} = join(' ', @_hosts);
} elsif ($_sort_order eq "severity") {
	$_sort_group{""} = join(' ', @_hosts);
	$_sort_sub = "sort_severity";
} elsif ($_sort_order eq "subnet") {
	&make_subnet_info();
	$_sort_title = "Subnet";
	$_sort_link = "saint_results_subnet.pl";
	for (@_hosts) { $_sort_group{$host_subnet{$_}} .= "$_ "; }
	$_sort_toc = "sort_ip";
} elsif ($_sort_order eq "type") {
	&make_hosttype_info();
	$_sort_title = "System type";
	$_sort_link = "saint_info_OStype.pl";
	for (@_hosts) { $_sort_group{$hosttype{$_}} .= "$_ "; }
} elsif ($_sort_order eq "domain") {
	&make_domain_info();
	$_sort_title = "Internet domain";
	$_sort_link = "saint_results_domain.pl";
	for (@_hosts) { $_sort_group{$host_domain{$_}} .= "$_ "; }
} elsif ($_sort_order eq "severity_type") {
	$_sort_title = "Problem type";
	$_sort_link = "saint_severity_hosts.pl";
	for $_host (@_hosts) {
		if (exists($severity_host_type_info{$_host})) {
			for $_type (keys %{$severity_host_type_info{$_host}}) {
				$_sort_group{$_type} .= "$_host ";
			}
		} else {
			$_type = "(none)";
			$_sort_group{$_type} .= "$_host ";
			$_not_linked{$_type} = 1;
		}
	}
	$_sort_note = "Note: a host may appear in more than one category.";
} elsif ($_sort_order eq "trusted_type") {
	$_sort_title = "Hosts trusted by $_trustee";
	for $_host (@_hosts) {
		for $_type (keys %{$trust_host_type{"$_host $_trustee"}}) {
			$_sort_group{$_type} .= "$_host ";
			$_not_linked{$_type} = 1;
		}
	}
	$_sort_note = "Note: a host may appear in more than one category.";
} elsif ($_sort_order eq "trustee_type") {
	$_sort_title = "Hosts trusting $_trusted";
	for $_host (@_hosts) {
		for $_type (keys %{$trust_host_type{"$_trusted $_host"}}) {
			$_sort_group{$_type} .= "$_host ";
			$_not_linked{$_type} = 1;
		}
	}
	$_sort_note = "Note: a host may appear in more than one category.";
}

#
# Make a nice table of contents.
#

if ($_sort_title) {
	print CLIENT <<EOF;
	<hr>
	<h3>$_sort_title: table of contents.</h3>
	<ul>
EOF
	for $_group (sort $_sort_toc keys %_sort_group) {
		$_count = $_bad = $sortabad = 0;
		for $_host (split(/\s/, $_sort_group{$_group})) {
			$_count++;
			$_bad++ if exists($severity_host_type_info{$_host});
		}
                if($severity_brown_type_info{$_group}) {
                   $_dot = "browndot";
                   $_alt = "BROWN";
                } elsif ($severity_green_type_info{$_group}) {
                   $_dot = "greendot";
                   $_alt = "GREEN";
                } elsif ($severity_yellow_type_info{$_group}) {
                   $_dot = "yellowdot";
                   $_alt = "YELLOW";
                } elsif ($severity_red_type_info{$_group}) {
                   $_dot = "reddot";
                   $_alt = "RED";
                } else {
                   $_dot = "blackdot";
                }
		$_counts = ($_bad != $_count) ? "($_bad/$_count)" : "($_count)";
		print CLIENT <<EOF;
		<dt><IMG SRC="$HTML_ROOT/dots/$_dot.gif" ALT="$_alt"> 
		<a href="#$_group">$_group</a> $_counts
EOF
	}
	print CLIENT <<EOF;
	</ul>
	$_sort_note
	<hr>
EOF
}

#
# Finally, list all those groups and their respective host members.
#

$_sort_sub = "sort_alpha" if $_sort_sub eq "";

for $_group (sort $_sort_toc keys %_sort_group) {
	%printed = ();
	if ($_sort_title) {
		print CLIENT <<EOF;
		<h3>
		<a name="$_group">
		$_sort_title: 
EOF
		if ($_not_linked{$_group}) {
			print CLIENT <<EOF;
			$_group.
EOF
		} else {
			($_GROUP = $_group) =~ tr / \//?!/;
			print CLIENT <<EOF;
			<a href="$_sort_link,$_GROUP,">$_group</a>.
EOF
		}
		print CLIENT <<EOF;
		</h3>
EOF
	}
	print CLIENT <<EOF;
	<ul>
EOF
#	for (sort $_sort_sub split(/\s/, $_sort_group{$_group})) {
#                if ($severity_green_host_count{$_}) {
#                        $_dot = "greendot";
#                        $_alt = "GREEN";
#                        $_bad = "($severity_green_host_count{$_})";
#                }
#                if ($severity_brown_host_count{$_}) {
#                        $_dot = "browndot";
#                        $_alt = "BROWN";
#                        $_bad = "($severity_brown_host_count{$_})";
#                }
#                if ($severity_yellow_host_count{$_}) {
#                        $_dot = "yellowdot";
#                        $_alt = "YELLOW";
#                        $_bad = "($severity_yellow_host_count{$_})";
#                }
#                if ($severity_red_host_count{$_}) {
#			$_dot = "reddot";
#			$_alt = "RED";
#			$_bad = "($severity_red_host_count{$_})";
#		}
#	}
        for (sort $_sort_sub split(/\s/, $_sort_group{$_group})) {
           if(exists($severity_red_host_count{$_})) {
              if($printed{$_} ne "1") {
                 $printed{$_} = "1";
                 $_dot = "reddot";
                 $_alt = "RED";
                 $yellow = $brown = $green = "";
                 if(exists($severity_yellow_host_count{$_})) {
                    $yellow = "Yellow: $severity_yellow_host_count{$_}";
                 }
                 if(exists($severity_brown_host_count{$_})) {
                    $brown = "Brown: $severity_brown_host_count{$_}";
                 }
                 if(exists($severity_green_host_count{$_})) {
                    $green = "Green: $severity_green_host_count{$_}";
                 }
                 print CLIENT <<EOF;
                 <dt><IMG SRC=$HTML_ROOT/dots/$_dot.gif ALT="$_alt">
                 <a href="saint_info_host.pl,$_,"> $_</a>
                 Red: $severity_red_host_count{$_}
                 $yellow
                 $brown
                 $green
EOF
              }
           }
        }
        for (sort $_sort_sub split(/\s/, $_sort_group{$_group})) {
           if(exists($severity_yellow_host_count{$_})) {
              if($printed{$_} ne "1") {
                 $printed{$_} = "1";
                 $_dot = "yellowdot";
                 $_alt = "YELLOW";
                 $red = $brown = $green = "";
                 if(exists($severity_red_host_count{$_})) {
                    $red = "Red: $severity_red_host_count{$_}";
                 }
                 if(exists($severity_brown_host_count{$_})) {
                    $brown = "Brown: $severity_brown_host_count{$_}";
                 }
                 if(exists($severity_green_host_count{$_})) {
                    $green = "Green: $severity_green_host_count{$_}";
                 }
                 print CLIENT <<EOF;
                 <dt><IMG SRC=$HTML_ROOT/dots/$_dot.gif ALT="$_alt">
                 <a href="saint_info_host.pl,$_,"> $_</a>
                 $red
                 Yellow: $severity_yellow_host_count{$_}
                 $brown
                 $green
EOF
              }
           }
        }
        for (sort $_sort_sub split(/\s/, $_sort_group{$_group})) {
           if(exists($severity_brown_host_count{$_})) {
              if($printed{$_} ne "1") {
                 $printed{$_} = "1";
                 $_dot = "browndot";
                 $_alt = "BROWN";
                 $red = $yellow = $green = "";
                 if(exists($severity_red_host_count{$_})) {
                    $red = "Red: $severity_red_host_count{$_}";
                 }
                 if(exists($severity_yellow_host_count{$_})) {
                    $yellow = "Yellow: $severity_yellow_host_count{$_}";
                 }
                 if(exists($severity_green_host_count{$_})) {
                    $green = "Green: $severity_green_host_count{$_}";
                 }
                 print CLIENT <<EOF;
                 <dt><IMG SRC=$HTML_ROOT/dots/$_dot.gif ALT="$_alt">
                 <a href="saint_info_host.pl,$_,"> $_</a>
                 $red
                 $yellow
                 Brown: $severity_brown_host_count{$_}
                 $green
EOF
              }
           }
        }
        for (sort $_sort_sub split(/\s/, $_sort_group{$_group})) {
           if(exists($severity_green_host_count{$_})) {
              if($printed{$_} ne "1") {
                 $printed{$_} = "1";
                 $_dot = "greendot";
                 $_alt = "GREEN";
                 $red = $yellow = $brown = "";
                 if(exists($severity_red_host_count{$_})) {
                    $red = "Red: $severity_red_host_count{$_}";
                 }
                 if(exists($severity_yellow_host_count{$_})) {
                    $yellow = "Yellow: $severity_yellow_host_count{$_}";
                 }
                 if(exists($severity_brown_host_count{$_})) {
                    $brown = "Brown: $severity_brown_host_count{$_}";
                 }
                 print CLIENT <<EOF;
                 <dt><IMG SRC=$HTML_ROOT/dots/$_dot.gif ALT="$_alt">
                 <a href="saint_info_host.pl,$_,"> $_</a>
                 $red
                 $yellow
                 $brown
                 Green: $severity_green_host_count{$_}
EOF
              }
           }
        }
        for (sort $_sort_sub split(/\s/, $_sort_group{$_group})) {
           if($printed{$_} ne "1") {
              $printed{$_} = "1";
              $_dot = "blackdot";
              $_alt = "BLACK";
              $red = $yellow = $brown = "";
              print CLIENT <<EOF;
              <dt><IMG SRC=$HTML_ROOT/dots/$_dot.gif ALT="$_alt">
              <a href="saint_info_host.pl,$_,"> $_</a>
EOF
              }
           }
        
	print CLIENT <<EOF;
	</ul>
EOF
}
