#
# really_unexclude_it.pl
# Removes listed entry to the exclusions list, then refreshes
# No checks done in this version

#2 modes of operation:
# really_unexclude_it.pl,"F",$encoded_fact,$myurl
#or
# really_unexclude_it.pl,"E",$encoded_excl,$myurl

#The first, "F" mode deletes all exclusions which match the given fact
#The second, "E" mode only deletes the given exclusion
#Neither cares whether some of the exclusions to be deleted have wild cards,
#and the "F" mode expects to get multiple exclusions (though doesn't care)

use strict;

require "perl/exclusions.pl";


my ($mode,$rec,$url) = split(/,/, $::html_script_args,3);

my $message;
$mode=uc $mode;
if ( $mode ne "F" && $mode ne "E" )
{	warn "Error calling really_unexclude_it.pl, invalid mode $mode";
print ::CLIENT <<EOF;
<h2>Error in perl script /reporting/really_unexclude_it.pl</h2>
Invalid mode $mode.
<p>Please inform maintainer of package.
<p>Your request to delete an exclusion has failed.
EOF
	return;
}

my $fact = &decode_url_arg($rec);
my @fact = split_fact($fact);
my $host=$fact[$::TARGET_FIELD];
my $sev =$fact[$::SERVICE_OUTPUT_FIELD];

my @exclist;

if ( $mode eq "F" ) 
{	@exclist= get_all_exclusions_matching_fact($fact);
} else
{	@exclist = ($fact);
}

if ( scalar (@exclist) == 0 )
{	warn "Error in really_unexclude_it.pl: fact doesn't match any exclusions\n";
	$message="Error in unexclude_it.pl, fact didn;t match any exclusions";
	&refresh_html(\*::CLIENT,$url,0,$message);
	return;
}

my $exc;
my $exclist="";
foreach $exc (@exclist)
{	drop_exclusion($exc);
	$exclist.=$exc .   "\n";
}

my $message=<<EOF;
<h2> Exclusions Deleted</h2>
The following exclusions have been deleted:
$exclist
EOF

&refresh_html(\*::CLIENT,$url,0,$message);

