#  This software was derived from SATAN 1.1.1 by Dan Farmer and Wietse Venema
#  (http://www.porcupine.org/satan).
#
#
#
#

use strict;

my $myurl="saint_exclusion_load.pl";

generate_html_header(\*::CLIENT,"SAINT Exclusion Load Results");

print ::CLIENT<<EOF;
<H1><Center>Exclusion Load Results Page</Center></H1>
<HR>
EOF


my $loadfile=$Exclusions::tmplf;
my $path=exclusion_file_path($loadfile);

my $sf_status;
if ( $Exclusions::tmpoptlf eq "yes" && $loadfile ne $Exclusions::savefile )
{	$Exclusions::savefile=$loadfile;
	$sf_status="<li>Savefile is now $loadfile (changed).";
} else
{	$sf_status="<li>Savefile is currently $Exclusions::savefile (unchanged).";
}

my $count;
my $read_status;
if ( $Exclusions::tmpoptm eq "overwrite" )
{	$count=read_exclusions($path);
	$read_status="<li>$count exclusions read from $path (overwrite mode).";
} elsif ( $Exclusions::tmpoptm eq "merge" )
{	$count=merge_exclusions($path);
	$read_status="<li>$count exclusions read from $path (merge mode).";
} else
{	warn "Invalid value for radio button tmpoptm\n";
	$read_status="<li>Error in form: illegal value $Exclusions::tmpoptm for radio button tmpoptm\n";
	$count=-1;
}
if ( $count == 0 )
{	$read_status=<<EOF;
<li>Error reading exclusions from file $path.
<li>See STDERR on SAINT http server for more information.
EOF
}

my $tmp_status=undef;
if ( $count<1 )
{	$tmp_status="<li><strong>EXCLUSIONS LOAD FAILED</strong>";
}


print ::CLIENT <<EOF;
<h3>Results</h3>
<ul>
$sf_status
$read_status
$tmp_status
</ul>
<p>
<hr>
<a href="saint_exclusion_manage_form.pl">Return to the Exclusion Management Form</a><br>
<a href="analysis.pl">Return to the Main Analysis Page</a><br>
<a href="../saint.html">Return to the Main SAINT Page</a><br>
EOF

&generate_html_footer(\*::CLIENT);
