#  This software was derived from SATAN 1.1.1 by Dan Farmer and Wietse Venema
#  (http://www.porcupine.org/satan).
#
#
#
#

use strict;

my $myurl="saint_exclusion_manage_form.pl";

generate_html_header(\*::CLIENT,"SAINT Exclusion Management");

print ::CLIENT<<EOF;
<H1><Center>Excluded Vulnerability Management Page</Center></H1>
<HR>
EOF

# Some vars
my ($vischecked, $ignorechecked) = (undef,undef);
if ( $Exclusions::display_ignored)
{	$vischecked="checked";
} else
{	$ignorechecked="checked";
}
my ($autosaveon, $autosaveoff) = (undef,undef);
if ( $Exclusions::autosave)
{	$autosaveon="checked";
} else
{	$autosaveoff="checked";
}

# Display a FORM to select the the exclusion handling options
print CLIENT <<EOF;
<FORM METHOD=POST ACTION="saint_exclusion_change_options.pl">

<H2>Determine Visibility of Excluded Severity Records</H2>
<UL>
<table border=0 cellpadding=3>
<tr><td><INPUT TYPE="radio" NAME="Exclusions::tmpvis" VALUE="yes"  $vischecked>
<strong>Excluded vulnerabilities are visible</strong></td>
</tr>
<tr><td><INPUT TYPE="radio" NAME="Exclusions::tmpvis" VALUE="no" $ignorechecked>
<strong>Do not display excluded vulnerabilities</strong></td>
</tr>
</table>
</UL>

<H2>Save Options</H2>
<UL>
<table border=0 cellpadding=3>
<tr><td><INPUT TYPE="radio" NAME="Exclusions::tmpas" VALUE="yes"  $autosaveon>
<strong>Automatically save changes to exclusions table</strong></td>
</tr>
<tr><td><INPUT TYPE="radio" NAME="Exclusions::tmpas" VALUE="no" $autosaveoff>
<strong>Changes to exclusion table must be saved manually</strong></td>
</tr>
<tr><td><strong>File to save to: </strong><INPUT TYPE="text" 
NAME="Exclusions::tmpsavfil" VALUE="$Exclusions::savefile">
</tr>
</table>
</UL>

<input type="submit" value="Apply the above changes">
</form>
<hr>
EOF

# Display a FORM for manual saving of the file
print CLIENT <<EOF;
<FORM METHOD=POST ACTION="saint_exclusion_save.pl">

<H2>Perform a manual save of the exclusions file</H2>
<UL>
<table border=0 cellpadding=3>
<tr><td><strong>File to save to: </strong><INPUT TYPE="text" 
NAME="Exclusions::tmpsavfil" VALUE="$Exclusions::savefile">
</tr>
</table>
</UL>
<input type="submit" value="Write exclusions file">
</form>
<hr>
EOF

# Display a FORM for manual loading of exclusions file
# Display a FORM to select the the exclusion handling options
print CLIENT <<EOF;
<FORM METHOD=POST ACTION="saint_exclusion_load.pl">

<H2>Load/Merge exclusions files</H2>
<UL>
<table border=0 cellpadding=3>
<tr><td><INPUT TYPE="radio" NAME="Exclusions::tmpoptm" VALUE="overwrite" >
<strong>Overwrite:Clear all current exclusions and load from named file
</strong></td>
</tr>
<tr><td><INPUT TYPE="radio" NAME="Exclusions::tmpoptm" VALUE="merge" checked>
<strong>Merge: load exclusions from named file on top of current</strong></td>
</tr>
<tr><td><strong>File to load: </strong><INPUT TYPE="text" 
NAME="Exclusions::tmplf" VALUE="$Exclusions::savefile">
</tr>
<tr><td><strong>Make the above the new savefile?  
Yes <INPUT TYPE="radio" NAME="Exclusions::tmpoptlf" VALUE="yes" checked>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
No  <INPUT TYPE="radio" NAME="Exclusions::tmpoptlf" VALUE="no">
</tr>
</table>
</UL>
<input type="submit" value="Load/Merge">
</form>
<hr>
EOF


&generate_html_footer(\*::CLIENT);
