#
# Show information about a specific host.
#
($_host, $_show_all_services) = split(/,/, $html_script_args);
($_type = $hosttype{$_host}) =~ tr / \//?!/;
my $myurl="saint_info_host.pl,$html_script_args";

&generate_html_header(\*::CLIENT,"Results - $_host");

print CLIENT <<EOF
<CENTER><H1>Results - $_host </H1></CENTER>
<hr><UL><UL>
<h3>General host information:</h3>
<dl>
EOF
;

#
# Refresh the host type and service tables.
#
&make_hosttype_exclusion_info();
&make_service_exclusion_info();
&make_subnet_exclusion_info();
&make_severity_exclusion_info();

$_exists = 0;
$_dot = "blackdot";
$_alt = "BLACK";

if (exists($hosttype{$_host})) {
	print CLIENT <<EOF;
        <dt><IMG SRC="$HTML_ROOT/dots/$_dot.gif" ALT="$_alt">
	Host type: <A HREF="saint_info_OStype.pl,$_type,">$hosttype{$_host}</A>
EOF
	$_exists = 1;
}

if (exists($nb_name{$_host})) {
	print CLIENT <<EOF;
        <dt><IMG SRC="$HTML_ROOT/dots/$_dot.gif" ALT="$_alt">
	Netbios Name: $nb_name{$_host}
EOF
	$_exists = 1;
}

if (exists($client_info{$_host})) {
	for (sort split(/\n/, $client_info{$_host})) {
		# Mask blanks and slashes
		($_service = $_) =~ tr / \//?!/;
		print CLIENT <<EOF;
                <dt><IMG SRC="$HTML_ROOT/dots/$_dot.gif" ALT="$_alt">
		<A HREF="saint_info_clients.pl,$_service,"> $_ </A> client
EOF
	}
	$_exists = 1;
}

if (exists($all_hosts{$_host})) {
	($_subnet = $all_hosts{$_host}{IP}) =~ s/\.[^.]*$//;
        $_dot = "blackdot";
	print CLIENT <<EOF;
        <dt><IMG SRC="$HTML_ROOT/dots/$_dot.gif" ALT="$_alt">
	Subnet <A HREF="saint_results_subnet.pl,$_subnet,"> $_subnet </A>
EOF
	$_exists = 1;
}

if (exists($total_trustee_count{$_host})) {
	$_count = split(/\s+/, $total_trustee_names{$_host});
	print CLIENT <<EOF;
        <dt><IMG SRC="$HTML_ROOT/dots/$_dot.gif" ALT="$_alt">
	$_count
	<A HREF="saint_results_trusting.pl,$_host,trustee_type,"> Trusting host(s) </a>
EOF
	$_exists = 1;
}

if (exists($total_trusted_count{$_host})) {
	$_count = split(/\s+/, $total_trusted_names{$_host});
	print CLIENT <<EOF;
        <dt><IMG SRC="$HTML_ROOT/dots/$_dot.gif" ALT="$_alt">
	$_count
	<A HREF="saint_results_trusted.pl,$_host,trusted_type,"> Trusted host(s) </a>
EOF
	$_exists = 1;
}

if (exists($all_hosts{$_host}) && defined($all_hosts{$_host}{'attack'})) {
	@_level = ('none', 'light', 'normal', 'heavy', 'heavyplus', 'top 20', 'custom');
	print CLIENT <<EOF;
        <dt><IMG SRC="$HTML_ROOT/dots/$_dot.gif" ALT="$_alt">
	Scanning level: @_level[1 + $all_hosts{$_host}{'attack'}]
EOF
	$_exists = 1;
}

if (exists($all_hosts{$_host}) && defined($all_hosts{$_host}{'time'})
	&& $all_hosts{$_host}{'time'} > 1) {
	$_time = &ctime($all_hosts{$_host}{'time'});
	print CLIENT <<EOF;
        <dt><IMG SRC="$HTML_ROOT/dots/$_dot.gif" ALT="$_alt">
	Last scan: $_time
EOF
	$_exists = 1;
}


print CLIENT "</dl>\n";


if (exists($server_info{$_host}) || exists($other_server_info{$_host})) {
        print CLIENT "<h3>Network Services:</h3><ul>\n";
	$_dot = "greendot";
	$_alt = "GREEN";
	if (exists($server_info{$_host})) {
	    for (sort split(/\n/, $server_info{$_host})) {
		# Mask blanks and slashes
		($_service = $_) =~ tr / \//?!/;
		print CLIENT <<EOF;
                <dt><IMG SRC="$HTML_ROOT/dots/$_dot.gif" ALT="$_alt">
		<A HREF="saint_info_servers.pl,$_service,"> $_ </A> server
EOF
	    }
	}
	if (exists($other_server_info{$_host})) {
	  $_count = split(/\n/, $other_server_info{$_host});
	  if (($_count < 5) || $_show_all_services) {
	    for (sort split(/\n/, $other_server_info{$_host})) {
		print CLIENT <<EOF;
		<dt><IMG SRC="$HTML_ROOT/dots/$_dot.gif" ALT="$_alt">
		$_ server
EOF
	    }
	  } else {
	    print CLIENT <<EOF;
		<dt><IMG SRC="$HTML_ROOT/dots/$_dot.gif" ALT="$_alt">
		$_count other services
		(<A HREF="saint_info_host.pl,$_host,all_services,">show
		all services</A>)
EOF
	  }
	}
	$_exists = 1;
}
print CLIENT <<EOF;
</ul>
EOF

my $txtstr=
     get_host_vulnerability_count_string($_host,$Exclusions::display_ignored);
my $color;

if (exists($severity_host_type_info{$_host}) &&
      ( $Exclusions::display_ignored ||
      any_nonexcluded_facts_by_host($_host)))
{     print CLIENT "<h3>Vulnerability information:  $txtstr</h3><dl>\n";
	for (keys %{$severity_host_type_info{$_host}}) {
		($_tutorials = $_) =~ tr / /_/;
		for (sort split(/\n/, $severity_host_type_info{$_host}{$_})) {
			&saint_split($_);
			if ($cve{$text}) {
			    $cve_ref = "(<A HREF=\"http://cve.mitre.org\">CVE</A>";
			    for (split(/\s+/, $cve{$text})) {
				$cve_ref .= " <A HREF=\"http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-$_\">$_</A>";
			    }
			    $cve_ref .= ")";
			} else {
			    $cve_ref = "";
			}
			if ($top20{$text} =~ /yes/) {
			    $top20_ref = "<IMG SRC=\"$HTML_ROOT/images/top20.gif\" ALT=\"top-20\">";
			} else {
			    $top20_ref = "";
			}
                         if($severity =~ /^z/) {
                            $color = "BROWN";
                         } elsif ($severity =~ /^y/) {
                            $color = "YELLOW";
                         } else {
                            $color = "RED";
                         }
                      $txtstr=<<EOF;
$top20_ref
<A HREF="$HTML_ROOT/tutorials/vulnerability/$_tutorials.html">$text</A>
$cve_ref
EOF
                      print_vulnerability_by_host_line(\*::CLIENT,
                              $txtstr, $color, $_, $myurl,
                              $Exclusions::display_ignored
);
		}
	}
	$_exists = 1;
}
print CLIENT <<EOF;
</dl>
EOF

# List host service info

if ($_exists) {
        $_dot = "blackdot";
	$_alt = "BLACK";
	print CLIENT <<EOF;
	<h3>Actions:</h3> <dl>
        <dt><IMG SRC="$HTML_ROOT/dots/$_dot.gif" ALT="$_alt">
	<A HREF="$HTML_SERVER/running/saint_run_form.pl,$_host,">Scan this host</a>
EOF
      print_show_hide_html_message(\*::CLIENT,$myurl,
              "<dt><IMG SRC=\"$HTML_ROOT/dots/$_dot.gif\" ALT=\"$_alt\">",
              "<\dt>");
      print CLIENT "\n</dl>\n";
} else {
	print CLIENT <<EOF;
	<h3>No information found on host $_host.</h3>
EOF
}

print CLIENT <<EOF;
<hr> <a href=$HTML_STARTPAGE> Back to the SAINT start page </a> |
<a href=analysis.pl> Back to SAINT Reporting and Analysis </a>
</UL></UL>
EOF

&generate_html_footer(\*::CLIENT);
