//bnf_createbr.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

//Create basic rule ( .txt ---> .h )
#include <iostream>
#include <fstream>
#include <string>
using namespace std;
char  buf[1024];
bool sget_line(ifstream& in,string& s)
{
   if (in.eof())
     return false;
   s="";
   char c;
   while (c!='\n' )
     {	
	if (in.get(c))
	  {
	     if (c!='\n')
	       {
		  if (c=='"')
		    {
		       s.push_back('\\');
		       s.push_back('"');     
		    }
		  else if (c=='\\')
		    {
		       s.push_back('\\');
		       s.push_back('\\');
		    }
		  else if (c=='\t')  //change tab to probel
		    s.push_back(' ');
		  else
		    s.push_back(c);
	       }
	  }
	else
	  c='\n';
     }
   //check may be contain only ' '
   bool is_zero=true;
   for (unsigned int i=0;i<s.size();i++)
     if (isprint(s[i]))
       is_zero=false;
   if (is_zero)
     return sget_line(in,s);
   return true;
}

int main(int argc,char**argv)
{
   if (argc != 2)
     {
	cout<<"Bad number of parameters, must be one rules_name"<<endl;
	exit(EXIT_FAILURE);
     }
   string in_name=string(argv[1]) + ".txt";
   string out_name=string(argv[1]) + ".h";
   ifstream in(in_name.c_str());
   ofstream out(out_name.c_str());
   if (!in || !out)
     {
	cout<<"Error then open file"<<endl;
	exit(EXIT_FAILURE);
     }
   string s;
   out<<"//"<<out_name<<endl;
   s=out_name;
   for (unsigned int i=0;i<s.size();i++)
     {
	s[i]=toupper(s[i]);
	if (s[i]=='.')
	  s[i]='_';
     }   
   out<<"#ifndef __MLTD_"<<s<<"__"<<endl;
   out<<"#define __MLTD_"<<s<<"__"<<endl;
   
   out<<"static const char* "<<argv[1]<<"[]={"<<endl;
   while (sget_line(in,s))
     out<<"       \""<<s<<'\"'<<','<<endl;
   out<<"NULL};"<<endl;
   out<<"#endif"<<endl;
   return 1;
}
