//bnf_parser.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "bnf_parser.h"
#include <cctype>
#include <stdexcept>
#include <iostream>
using namespace std;

bnf_parser::bnf_parser(const char** defrule)
{
   load_defrule(defrule);
}
//                                                                            
void bnf_parser::load_defrule(const char** defrule)
{
   clear();
   int n=0;
   string rule_name,rule; 
   while (bnf_ruleparser::read_next_rule(defrule,n,rule_name,rule)) 
        //first loop not parse
     {
	if (is_rule_exist(rule_name))
	  throw logic_error("Error in bnf_parser::bnf_parser(): Duplicate of rule");
	rules[rule_name]=new bnf_rule(rule_name);
     }
   n=0;
   while (bnf_ruleparser::read_next_rule(defrule,n,rule_name,rule))
     reset_rule(rule_name,rule);
}
//                                                                            
bnf_parser::~bnf_parser()
{
   clear();
}
//                                                                            
void bnf_parser::reset_rule(string rule_name,string rule)
{
   if (!is_rule_exist(rule_name))
     throw logic_error(string("Error in bnf_parser::reset_rule rule=") +
		       rule_name + "not found =");
   bnf_ruleparser rp(rules);
   vector<bnf_ruleitem*> items;
   rp.create_itemlist(items, rule.begin(), rule.end());
   rules[rule_name] -> reset_items(items); 
}
//                                                                            
void bnf_parser::reset_rule(string rule_name_rule)
{
   string rn;
   string r;
   if (!bnf_ruleparser::read_ruleline(rule_name_rule.c_str(), rn , r))
     throw runtime_error(string("Error in bnf_parser::reset_rule string=")+
			 rule_name_rule + " not is rule = smth");
   reset_rule(rn,r);
}
//                                                                            
void bnf_parser::add_rule(string rule_name,string rule)
{
   if (!is_rule_exist(rule_name))  //add new rule if need
     rules[rule_name]=new bnf_rule(rule_name);
   bnf_ruleparser rp(rules);
   vector<bnf_ruleitem*> items;
   rp.create_itemlist(items,rule.begin(),rule.end());
   rules[rule_name] -> reset_items(items);
}
//                                                                            
void bnf_parser::add_rule(string rule_name_rule)
{
   string rn;
   string r;
   if (!bnf_ruleparser::read_ruleline(rule_name_rule.c_str(), rn , r))
     throw runtime_error(string("Error in bnf_parser::add_rule string=")+
			 rule_name_rule + " not is rule = smth");
   add_rule(rn,r);
}
//                                                                            
bool bnf_parser::try_parse(bnf_parsval&pv,string root_rule,
			   const string& toparse,
			   int& err_pos,string& err_rule)
{
   pv.clean();
   if (!is_rule_exist(root_rule))  //slow !!!!!
     throw logic_error(string("Error in bnf_parser::parser unknown rule"));
   str_cit init_it= toparse.begin();
   str_cit curr   = toparse.begin();
   str_cit err_it = toparse.end();
   bool rez=rules[root_rule]->try_parse( pv, curr, toparse,
					 err_it, err_rule );
   if (rez && curr!=toparse.end())  //hm... not the end
     {
	cout<<"Warning in bnf_parser::try_parse Not end"<<endl;
	err_pos=curr - init_it;
	err_rule=rules[root_rule]->get_name();
	return false;
     }
   err_pos = err_it - toparse.begin();
   return rez;
}
//                                                                            
bool bnf_parser::try_parse(bnf_parsval& p,string root_rule,const char* toparse,
			   int size,int &err_pos,string&err_rule)
{
   string tp(toparse,size);
   return try_parse(p,root_rule,tp,err_pos,err_rule);
}
//                                                                            
bool bnf_parser::try_parse(bnf_parsval& p, string root_rule,
			   const string& toparse)
{
   string err_rule;
   int err_pos;
   return try_parse(p,root_rule,toparse,err_pos,err_rule);
}
//                                                                            
bool bnf_parser::try_parse(bnf_parsval& p, string root_rule,
			   const char* toparse,int size)
{
   string err_rule;
   int err_pos;
   return try_parse(p,root_rule,toparse,size,err_pos,err_rule);
}
//                                                                            
void bnf_parser::reparse(string root_rule,string&rez,int r_len)
{
   rez.resize(0);
   if (!is_rule_exist(root_rule))
     throw logic_error("Error in bnf_parser::reparse unknown root_rule");
   rules[root_rule]->reparse(rez,r_len);
}
//                                                                            
void bnf_parser::clear()
{
   map<string,bnf_rule*>::iterator it;
   for (it=rules.begin();it!=rules.end();it++)
     delete it->second;
   rules.clear();
}
//                                                                            

