//bnf_parsval.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "bnf_parsval.h"
#include <iostream>
using namespace std;

bnf_parsval::~bnf_parsval()
{
   clean();
}
//                                                                            
void bnf_parsval::move_pvs_from(bnf_parsval& pv)
{
   for (unsigned int i=0;i<pv.pvs.size();i++)
     pvs.push_back(pv.pvs[i]);
   pv.pvs.resize(0);
}
//                                                                            
void bnf_parsval::get(string rname,vector<string>& want)
{
   want.resize(0);
   vector<bnf_parsval*> tmp;
   get(rname,tmp);
   for (unsigned int i=0;i<tmp.size();i++)
     want.push_back(tmp[i]->get_data());
}
//                                                                            
void bnf_parsval::get(string rname,vector<bnf_parsval*>&want)
{
   want.resize(0);
   _get(rname,want);
}
//                                                                            
bool bnf_parsval::is_present(string s)
{
   vector<bnf_parsval*> v;
   get(s,v);
   return v.size()>0;
}
//                                                                            
bool bnf_parsval::is_npresent(string s,int i)
{
   vector<bnf_parsval*> v;
   get(s,v);
   return (int)v.size()==i;
}
//                                                                            
bool bnf_parsval::get_one(string rule,string& rez)
{
   vector<bnf_parsval*> v;
   get(rule,v);
   if (v.size()!=1)
     return false;
   rez=v[0]->get_data();
   return true;
}
//                                                                            
bool bnf_parsval::get_one(string rule,bnf_parsval*& rez)
{
   vector<bnf_parsval*> v;
   get(rule,v);
   if (v.size()!=1)
     return false;
   rez=v[0];
   return true;
}
//                                                                            
int bnf_parsval::get_quan(string rule)
{
   vector<bnf_parsval*> v;
   get(rule,v);
   return v.size();
}
//                                                                            
void bnf_parsval::print(int sm)
{
   cout<<string(sm,' ')<<"name="<<name()<<" pos="<<position()<<" data= <";
   for (unsigned int i=0;i<raw_data.size();i++)
     if (isprint(raw_data[i]))
       cout<<raw_data[i];
   else 
     cout<<"%"<<(unsigned int)raw_data[i];
   cout<<">"<<endl;
   for (unsigned int i=0;i<pvs.size();i++)
     pvs[i]->print(sm+5);
}
//                                                                            
void bnf_parsval::clean()
{
   for (unsigned int i=0;i<pvs.size();i++)
     delete pvs[i];
   pvs.resize(0);
}
//                                                                            
void bnf_parsval::_get(string rname,vector<bnf_parsval*>& want )
{
   if (rname==name())
     want.push_back(this);
   else 
     for (unsigned int i=0;i<pvs.size();i++)
       pvs[i]->_get(rname,want);
}
//                                                                            
