//bnf_parsval.h
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#ifndef __SEGER__MLTD_BNF_PARSVAL_H__
#define __SEGER__MLTD_BNF_PARSVAL_H__

#include <string>
#include <vector>

using namespace std;

class bnf_parsval
{
 public:
   bnf_parsval()  {_position=string::npos;};
   ~bnf_parsval();
   string& name() {return _name;};
   string::size_type& position(){return _position;};
     //!!! position can be == toparse.size() (for last rule!)
   
   void add_data(string str){raw_data+=str;};
   
   const string& get_data(){return raw_data;};    //get as string
   
   void add_parsval(bnf_parsval* pv){pvs.push_back(pv);};
   void move_pvs_from(bnf_parsval& pv);   
   
   void get(string name,vector<bnf_parsval*>&);
   void get(string name,vector<string>&);
   
   bool is_present(string name);
   bool is_npresent(string name,int quant);
   bool get_one(string name,string& rez);
   bool get_one(string name,bnf_parsval* &);
   int get_quan(string name);
   void print(int sm=0);
   void clean();
 private:
   string _name;
   string  raw_data;
   string::size_type _position;
   vector<bnf_parsval*> pvs;
 private:
   void _get(string name,vector<bnf_parsval*>&); //not resize vector
};
//                                                                            
#endif
