//bnf_rule.h
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#ifndef __SEGER__MLTD__BNF_RULE_H__
#define __SEGER__MLTD__BNF_RULE_H__

#include <string>
#include <vector>
#include "bnf_parsval.h"
#include "bnf_ruleitem.h"
#include "bnf_strtype.h"
using namespace std;

class bnf_rule
{
 public:
   bnf_rule(string name_) {name=name_;};
   ~bnf_rule(){clear_items();};
   void reset_items(vector<bnf_ruleitem*>& r);
   bool try_parse(bnf_parsval&, str_cit& curr, const string& toparse, 
		  str_cit & err_it,string& err_rule);
   void reparse(string&rez, int r_len);
   const string& get_name(){return name;};
 private:
   string name;
   vector<bnf_ruleitem*> items;        //can be -- rule    
                                       //       -- string  
	       		               //       -- Group   
	 			       //       -- OR GROUP
 private:
   void clear_items();
};

//                                                                            

class bnf_ruleitem_rule:public bnf_ruleitem
{
 public:
   bnf_ruleitem_rule(int min, int max, bnf_rule*);
 protected:
   virtual bool pure_try_parse(bnf_parsval& ,str_cit& curr,
			       const string&toparse,
			       str_cit& err_it, string & err_rule);
   virtual void pure_reparse(string&rez,int r_len);
  private:
   bnf_rule* self_rule;
};


#endif
