//bnf_ruleparser.h
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#ifndef __SEGER__MLTD_BNF_RULEPARSER_H__
#define __SEGER__MLTD_BNF_RULEPARSER_H__

#include "bnf_rule.h"
#include "bnf_strtype.h"
#include <map>
using namespace std;

class bnf_ruleparser
{
 public:
   bnf_ruleparser(map<string,bnf_rule*>& rule_map_) {rule_map = & rule_map_ ;};
   
   void create_itemlist(vector<bnf_ruleitem*>&, str_cit from, str_cit end);
 private:
   bnf_ruleitem* create_str_item(str_cit &from , str_cit end,
				 int min, int max); 
                                //should begin with '"'
   bnf_ruleitem* create_hval(str_cit& from, str_cit end, int min, int max);
   bnf_ruleitem* create_group(str_cit& from, str_cit end,
			      char open, char close, int min,int max);
   bnf_ruleitem* create_rule_item(str_cit& from, str_cit end,
				  int min, int max);
   
   int read_hval(str_cit& from, str_cit end);
   int conv_hdigit(char c);
   void read_minmax(str_cit& from, str_cit end, int& min, int& max);
   static void error(string);
 private:
   map<string,bnf_rule*> * rule_map;
 public:
   static bool read_next_rule(const char**rlist,int & n, string& rule_name,
			      string & rule);
   static bool read_ruleline(const char* rline, string& rule_name,
			     string& rule);
   static void remove_comments(string& s);  
                         //remove ; comments (";" is not comment)
};


#endif
