//qsipb_gen.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "qsipb_gen.h"
#include <qlayout.h>
#include <qlabel.h>
#include <qhgroupbox.h>

qsipb_gen::qsipb_gen(QWidget* parent):QTabWidget(parent)
{
   stest=new qsipb_stmanager;
   htest=new qsipb_handtest;
   addTab(stest,"Send-Recv Tests");
   addTab(htest,"Hand Test");
   connect(stest,SIGNAL(is_tohandtest(sipb_stpacket&)),this,
	   SLOT(want_handtest(sipb_stpacket&)));
   
   //add about information
   QWidget* about_w=new QWidget();
   addTab(about_w,"About");
   QGridLayout* about_glay=new QGridLayout(about_w,3,3);
   about_glay->setRowStretch(0,1);
   about_glay->setRowStretch(2,1);
   about_glay->setColStretch(0,1);
   about_glay->setColStretch(2,1);
   QHGroupBox* about_gb=new QHGroupBox(about_w);
   QLabel* about_l=
     new QLabel("Sipbomber:    SIP-implementation tester\n"
		"company:    Metalink LTD  - www.metalinkltd.com\n"
		"author:    Sergey Rodionov (email - seger@metalinkltd.com)\n"
		"this program is distributed under GPL license",
		about_gb);
   about_l->setFont(QFont("",12));
   about_glay->addWidget(about_gb,1,1);
   
   //about Caption
   setCaption(SIPB_CAPTION_IDLE);
   n_run_test=0;
   connect(htest,SIGNAL(is_somerun()),this,SLOT(want_is_somerun()));
   connect(htest,SIGNAL(is_somestop()),this,SLOT(want_is_somestop()));

   connect(stest,SIGNAL(is_somerun()),this,SLOT(want_is_somerun()));
   connect(stest,SIGNAL(is_somestop()),this,SLOT(want_is_somestop()));
}
//                                                                            
void qsipb_gen::keyPressEvent(QKeyEvent* ev)
{
   if ((ev->state()==Qt::ControlButton && ev->key()==Qt::Key_X) ||
       (ev->state()==Qt::ControlButton && ev->key()==Qt::Key_Q))
     emit is_want_quit();
}
//                                                                            
void qsipb_gen::want_handtest(sipb_stpacket& p)
{
   htest->want_set_packet(p);
   showPage(htest);
}
//                                                                            
void qsipb_gen::want_is_somerun()
{
   setCaption(SIPB_CAPTION_RUNNING);
   n_run_test++;
}
//                                                                           
void qsipb_gen::want_is_somestop()
{
   if (n_run_test <= 0)  //it's imposible
     qFatal("Logic error in qsipb_gen::want_is_somestop");
   n_run_test--;
   if (n_run_test==0)
     setCaption(SIPB_CAPTION_IDLE);
}
//                                                                           
