//qsipb_inputparamset.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "qsipb_inputparamset.h"
#include <qhbox.h>
#include <qvbox.h>
#include <qlabel.h>
#include <qlayout.h>

qsipb_param_wrapper::qsipb_param_wrapper(sipb_paramlist* pl,int num_,
					 QWidget* parent):QWidget(parent)
{
   edit=0;
   cob_box=0;
   num=num_;
   QHBoxLayout* layout=new QHBoxLayout(this);

   QLabel*l =new QLabel(pl->get_name(num).c_str(),this);
   layout->addWidget(l,5);
   
   if (pl->get_voriants(num).size()==0)  //--> use QLineEdit
     {
	edit=new QLineEdit(this);
	edit->setValidator(pl->create_val(edit,num));
	edit->setText(pl->get_rez(num).c_str());
	layout->addWidget(edit,5);
     }
   else  //--->use QComboBox
     {
	cob_box =new QComboBox(false,this);  //create readonly combobox
	for (unsigned int i=0;i<pl->get_voriants(num).size();i++)
	  cob_box->insertItem(pl->get_voriants(num)[i].c_str());
	set_cob_box_text(pl->get_rez(num));
	layout->addWidget(cob_box,5);
     }
   chk_box=new QCheckBox(this);
   if (pl->get_is_global(num))
     chk_box->toggle();
   layout->addWidget(chk_box,1);
   
   connect(chk_box,SIGNAL(toggled(bool)),this,
		SLOT(want_change_is_global(bool)));
}
//                                                                            
string qsipb_param_wrapper::get_rez()
{
   if ( ( edit==0 && cob_box==0 ) || ( edit!=0 && cob_box!=0 ) )
     qFatal("qsipb_param_wrapper::get_rez");
   if (edit) 
     return (const char*)edit->text().utf8();
   return (const char*)cob_box->currentText().utf8();
}
//                                                                            
void qsipb_param_wrapper::set_text(string s)
{
   if ( ( edit==0 && cob_box==0 ) || ( edit!=0 && cob_box!=0 ) )
     qFatal("qsipb_param_wrapper::set_text");
   if (edit)
     edit->setText(s.c_str());
   else
     set_cob_box_text(s);
}
//                                                                            
void qsipb_param_wrapper::want_change_is_global(bool b)
{
   emit is_change_is_global(num,b);
}
//                                                                            
void qsipb_param_wrapper::set_cob_box_text(string str)
{
   int index=-1;
   if (!cob_box)
     qFatal("Error in qsipb_param_wrapper::set_cob_box_text cob_box==0");
   for (int i=0;i<cob_box->count();i++)
     if (str == (const char*)cob_box->text(i).utf8())
       index=i;
   if (index==-1)
     qFatal("qsipb_param_wrapper::set_cob_box_text not find s in box");
   cob_box->setCurrentItem(index);
}
//                                                                            
//                                                                            
qsipb_inputparamset::qsipb_inputparamset(QWidget* parent)
  :QVGroupBox(parent)
{
   local=0;
   global=0;
   base_box=0;
}
//                                                                            
void qsipb_inputparamset::reset(sipb_paramlist* local_,sipb_paramlist*global_)
{
   if (base_box)
     make_results();
   if ( base_box != 0 || local != 0 || global != 0 || params.size() != 0)
     qFatal("Error in qsipb_inputparamset::set");
   local=local_;
   global=global_;
   base_box=new QVBox(this);
   local->copy_new_toglobal(*global);
   local->set_fromglobal(*global);
   for (int i=0;i<local->size();i++)
     {
	params.push_back(new qsipb_param_wrapper(local,i,base_box));
	connect(params.back(),SIGNAL(is_change_is_global(int,bool)),this,
		SLOT(want_change_is_global(int,bool)));
     }
   base_box->show();
}
//                                                                            
void qsipb_inputparamset::make_results()
{
   if (!base_box) //not show anithing
     return;
   //get global parameters and write in global and local
   //local parameter write to local
   if ((int)params.size() != local->size())
     qFatal("Intarnal error in qsipb_inputparamset::make_results");
   for (unsigned int i=0;i<params.size();i++)
     get_from_param(i);
   local=0;
   global=0;
   if (!base_box->close(true))
     qFatal("Can't close base_box in qsipb_inputparamset::make_results");
   base_box=0;
   params.resize(0);
   base_box=0;
}
//                                                                            
void qsipb_inputparamset::want_change_is_global(int i,bool t)
{
   if (local->get_is_global(i)==t)
     qFatal("Error in qsipb_inputparamset::want_change_global global->global");
   get_from_param(i);
   if (t)  //if want change to general
     {
	local->set_is_global(i,true);
	if (global->check_name(local->get_name(i)))  //rule exist
	  {
	     local->set_rez(i, global->get( local->get_name(i) ));
	     params.at(i)->set_text(local->get_rez(i).c_str());
	  }
	else  //new global rule
	  local->copy_new_toglobal(*global);
     }
   else  //if want make local rule
     local->set_is_global(i,false);	
}
//                                                                            
void qsipb_inputparamset::get_from_param(int i)
{
   if (local->get_is_global(i))
     {
	local->set_rez(i,params.at(i)->get_rez());
	global->set_rez(local->get_name(i),params.at(i)->get_rez());
     }
   else
     local->set_rez(i,params.at(i)->get_rez());
}
//                                                                            
