//qsipb_packetedit.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "qsipb_packetedit.h"
#include <qlayout.h>

qsipb_packetedit::qsipb_packetedit(QWidget* parent):QWidget(parent)
{
   QVBoxLayout* gen_vb=new QVBoxLayout(this);
   t=new QTextEdit(this);   
   gen_vb->addWidget(t);
   t->setReadOnly(false);
   t->setTextFormat(PlainText);
   t->setWordWrap(QTextEdit::NoWrap);
}
//                                                                            
void qsipb_packetedit::set_packet(const string& p)
{
   t->setText(QString::fromUtf8(p.data(),p.size()));   
}
//                                                                            
void qsipb_packetedit::get_packet(string& str,string crlf)
{
   //TODO: It's may be not portable!!!!
   //TODO: Do it faster
   str.clear();
   QString tmp=t->text();
   for (unsigned int i=0;i<tmp.length();i++)
     {
	if (tmp[i]==0)
	  str+=(char)0;
	else
	  {
	     QString tmp_char;
	     tmp_char.fill(tmp[i],1);
	     str+=tmp_char.utf8();
	  }
     }
   //replace \n --> crlf
   string::size_type pos=0;
   while (pos<str.size())
     {
	if (str[pos]=='\x0A')  //<--- may be work only in linux!
	  {
	     str.replace(pos,1,crlf);  
	     pos+=crlf.size();
	  }
	else
	  pos++;
     }
}
