//qsipb_packetview.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "qsipb_packetview.h"
#include "sipb_addfun.h"
#include <qlayout.h>
#include <qpushbutton.h>
#include <qhbuttongroup.h>
#include <qfiledialog.h>
#include <qfile.h>
#include <qmessagebox.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>


qsipb_packetview::qsipb_packetview(QWidget* parent):QWidget(parent)
{
   QVBoxLayout* gen_vb=new QVBoxLayout(this);
   QHBoxLayout* b_hb  =new QHBoxLayout(gen_vb,2);
   t=new QTextEdit(this);
   gen_vb->addWidget(t);
   
   QPushButton* pb_save=new QPushButton("Save(pure data)",this);
   b_hb->addWidget(pb_save);
   
   QPushButton* pb_show_info=new QPushButton("info",this);
   b_hb->addWidget(pb_show_info);
   
   b_hb->addWidget(new QWidget(this),1);

   QButtonGroup *bg_typeview=new QHButtonGroup(this);
   bg_typeview->setRadioButtonExclusive(true);
   rb_simple_view=new QRadioButton("text",bg_typeview);
   rb_semidec_view=new QRadioButton("semi-dec",bg_typeview);
   rb_simple_view->toggle();
   b_hb->addWidget(bg_typeview);
   
   QPushButton* pb_handtest=new QPushButton("To Hand Test",this);
   b_hb->addWidget(pb_handtest);
   
   
   connect(pb_save,SIGNAL(clicked()),this,SLOT(want_save()));
   connect(pb_show_info,SIGNAL(clicked()),this,SLOT(want_show_info()));
   connect(pb_handtest,SIGNAL(clicked()),this,SLOT(want_handtest()));
   connect(rb_simple_view,SIGNAL(toggled(bool)),
	   this,SLOT(want_simple_view(bool)));
   connect(rb_semidec_view,SIGNAL(toggled(bool)),this,
	   SLOT(want_semidec_view(bool)));
   
   t->setReadOnly(true);
   t->setTextFormat(PlainText);
   t->setWordWrap(QTextEdit::NoWrap);
   
}
//                                                                            
void qsipb_packetview::set_packet(sipb_stpacket* buf)
{
   pack=*buf;
   if (rb_simple_view->state()==QButton::On)
     want_simple_view(true);
   else if (rb_semidec_view->state()==QButton::On)
     want_semidec_view(true);
   else
     qFatal("Error in qsipb_packetview::set_packet");
}
//                                                                            
void qsipb_packetview::want_handtest()
{
   emit is_tohandtest(pack);
}
//                                                                            
void qsipb_packetview::want_simple_view(bool b)
{
   if (!b)
     return;
   t->setText(QString::fromUtf8(pack.pack.data(),pack.pack.size()));
}
//                                                                            
void qsipb_packetview::want_semidec_view(bool b)
{
   //TODO: it's too too too slow... And bad making: rewrite it.
   if (!b)
     return;
   t->clear();
   string tmp_print;
   string tmp_notprint;
   bool create_new_para;
   string::size_type pos=0;
   t->hide();
   while (pos < pack.pack.size())
     {
	create_new_para=false;
	if (pack.pack[pos]=='\x0A')  //may be CRLF=LF
	  {
	     tmp_notprint="<10>";
	     create_new_para=true;
	  }
	else if (pack.pack[pos]=='\x0D' && 
		 ( (pos==pack.pack.size()-1) || pack.pack[pos+1]!='\x0A')  )
	  //may be CRLF=CR
	  {
	     tmp_notprint="<13>";
	     create_new_para=true;
	  }
	else if (pack.pack[pos]=='\x0D' && (pos != pack.pack.size()-1) &&
		 pack.pack[pos]=='\x0A') //may be CRLF=CRLF
	  {
	     tmp_notprint="<13><10>";
	     create_new_para=true;
	     pos++;
	  }
	else
	  {
	     create_new_para=false;
	     if (isprint(pack.pack[pos]))
	       tmp_print+=pack.pack[pos];
	     else
	       tmp_notprint="<"+int_to_str((unsigned char)pack.pack[pos]) + ">";
	  }
	if (tmp_notprint.size() != 0) //need print not print :)
	  {
	     if (tmp_print.size() != 0)
	       {
		  t->setColor(black);
		  insert_toend(tmp_print);
		  tmp_print.clear();
	       }
	     t->setColor(darkGray);
	     insert_toend(tmp_notprint);
	     if (create_new_para)
	       t->append("");
	     tmp_notprint.clear();
	  }
	pos++;
     }
   if (tmp_notprint.size()!=0)
     qFatal("Error in qsipb_packetview::want_semidec_view");
   t->setColor(black);
   if (tmp_print.size()!=0)
     insert_toend(tmp_print);
   t->show();
}
//                                                                            
void qsipb_packetview::want_save()
{
   QString fn=QFileDialog::getSaveFileName("","",this,"save file dialog");
   if (fn.length()==0)
     return;
   QFile out(fn);
   if (out.exists())
     {
	if (QMessageBox::
	    information(this,"Overwrite","This file exist. Overwrite it?",
			QMessageBox::Yes,QMessageBox::No) != 
	    QMessageBox::Yes)
	  return;
     }
   if (out.open( IO_WriteOnly ))
     {
	QTextStream outs(&out);
	outs.writeRawBytes(pack.pack.data(),pack.pack.size());
     }
   else
     QMessageBox::warning(this,"Can't write to this file",
			  "Can't write to this file",QMessageBox::Ok,0);
}
//                                                                            
void qsipb_packetview::want_show_info()
{
   QString info;
   QTextStream outs(info,IO_WriteOnly);
   outs<<"type="<<pack.type<<"\n";
   outs<<"sr_type=";
   if (pack.is_send)
     outs<<"SEND   (resend "<<pack.nsend<<" times)";
      else
     outs<<"RECV";
   outs<<"\n";
   outs<<"server="<<inet_ntoa(pack.serv_ip)<<":"<<pack.serv_port<<"\n";
   outs<<"my_port="<<pack.my_port<<"\n";
   outs<<"Time stamp="<<pack.t.toString()<<"\n";
   outs<<"Size="<<pack.pack.size()<<"\n";
   for (int i=0;i<pack.errwarn.err_size();i++)
     outs<<"Error:   "<<QString(pack.errwarn.err(i).c_str())<<"\n";
   for (int i=0;i<pack.errwarn.warn_size();i++)
     outs<<"Warning: "<<QString(pack.errwarn.warn(i).c_str())<<"\n";
   for (int i=0;i<pack.errwarn.info_size();i++)
     outs<<"Info:    "<<QString(pack.errwarn.info(i).c_str())<<"\n";
   QMessageBox::information(this,"packet information",info,QMessageBox::Ok);
}
//                                                                            
void qsipb_packetview::insert_toend(string s)
{
   QString qtmp=QString::fromUtf8(s.data(),s.size());
   t->insertAt(qtmp,t->paragraphs()-1,t->paragraphLength(t->paragraphs()-1));
}
//                                                                            
