//qsipb_pwrapper.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "qsipb_pwrapper.h"
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>


qsipb_pwrapper::qsipb_pwrapper(QListViewItem * parent,
			       QListViewItem * after,
			       sipb_stpacket * pack_, int id_)
  :QListViewItem(parent,after)
{
   pack  = pack_;
   _id   = id_;
}
//                                                                            
void qsipb_pwrapper::write_to(QTextStream& outs)
{
   outs<<"---------------------------------------------------------------\n";
   outs<<"Packet ID="<<id()<<"\n"; 
   outs<<"  type="<<pack->type<<"\n";
   outs<<"  sr_type=";
   if (pack->is_send)
     outs<<"SEND   (resend "<<pack->nsend<<" times)";
   else
     outs<<"RECV";
   outs<<"\n";
   outs<<"  server="<<inet_ntoa(pack->serv_ip)<<":"<<pack->serv_port<<"\n";
   outs<<"  my_port="<<pack->my_port<<"\n";
   outs<<"  Time stamp="<<pack->t.toString()<<"\n";
   outs<<"  Size="<<pack->pack.size()<<"\n";
   for (int i=0;i<pack->errwarn.err_size();i++)
     outs<<"  Error:   "<<QString(pack->errwarn.err(i).c_str())<<"\n";
   for (int i=0;i<pack->errwarn.warn_size();i++)
     outs<<"  Warning: "<<QString(pack->errwarn.warn(i).c_str())<<"\n";
   for (int i=0;i<pack->errwarn.info_size();i++)
     outs<<"  Info:    "<<QString(pack->errwarn.info(i).c_str())<<"\n";
   outs<<"\nSelf packet: \n";
   outs<<"- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -\n";
   outs.writeRawBytes(pack->pack.data(),pack->pack.size());
   outs<<"\n";
   outs<<"---------------------------------------------------------------\n";
}
//                                                                            
QPixmap qsipb_pwrapper::create_vpixmap(sipb_errwarn::vt v)
{
   QPixmap pm(10,10);
   if (v==sipb_errwarn::VT_GOOD)
     pm.fill(green);
   if (v==sipb_errwarn::VT_WARN)
     pm.fill(yellow);
   if (v==sipb_errwarn::VT_ERR)
     pm.fill(red);
   return pm;
}
