//qsipb_pwrapper.h
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

//packet wrapper (basic)
#ifndef __SEGER__MLTD__QSIPB_PWRAPPER_H__
#define __SEGER__MLTD__QSIPB_PWRAPPER_H__

#include "sipb_stpacket.h"
#include <qlistview.h>
#include <qtextstream.h>
#include <qpixmap.h>


class qsipb_pwrapper:public QListViewItem
{
 public:
   qsipb_pwrapper(QListViewItem * parent, QListViewItem* after,
		  sipb_stpacket * pack, int id);
   ~qsipb_pwrapper(){delete pack;};
   int id(){return _id;};
   sipb_stpacket* get_pack(){return pack;};
   
   int psend(){return pack->nsend;};  //may be >1 (if resend)
   int precv(){return !pack->is_send;};  //0 or 1
   
   virtual void change_text()=0;  //change text information
   
   void write_to(QTextStream&);
 private:
   sipb_stpacket* pack;
   int _id;
 public:
   static QPixmap create_vpixmap(sipb_errwarn::vt);
};

#endif
