//qsipb_chooser.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "qsipb_stchooser.h"
#include "sipb_stests.h"

qsipb_stchooser::qsipb_stchooser(QWidget* parent,vector<sipb_stest*> &tests)
  :QHBox(parent)
{
   lv1=     new QListView(this);
   bbox=    new QVBox(this);
   lv2=     new QListView(this);
   setStretchFactor(lv1,5);
   setStretchFactor(bbox,2);
   setStretchFactor(lv2,5);
   btoright=new QPushButton(bbox);
   btoleft= new QPushButton(bbox);
   ball=    new QPushButton(bbox);
   brefresh=new QPushButton(bbox);
   bbox->setMaximumHeight(100);
   btoright->setMaximumHeight(20);
   btoleft->setMaximumHeight(20);
   ball->setMaximumHeight(20);
   brefresh->setMaximumHeight(20);
   btoright->setText("-->");
   btoleft->setText("<--");
   ball->setText("All");
   brefresh->setText("Refresh");
   lv1->addColumn("From");
   lv2->addColumn(" To ");
   lv1->setColumnWidthMode(0,QListView::Manual);
   lv2->setColumnWidthMode(0,QListView::Manual);
   
   connect(btoright,SIGNAL( clicked() ), this, SLOT( want_toright() ) );
   connect(btoleft, SIGNAL( clicked() ), this, SLOT( want_toleft() )  );
   connect(ball,    SIGNAL( clicked() ), this, SLOT( want_all() )     );
   connect(brefresh,SIGNAL( clicked() ), this, SLOT( want_refresh() ) );
   connect(lv2,SIGNAL(selectionChanged(QListViewItem*)),
	   this, SLOT(want_is_changeright(QListViewItem*)));
   
   connect(lv1,  SIGNAL( doubleClicked(QListViewItem*) ), 
	   this, SLOT( want_toright(QListViewItem* ) ) );
   connect(lv2,  SIGNAL( doubleClicked(QListViewItem*) ),
	   this, SLOT ( want_toleft(QListViewItem* )));

   for (unsigned int i=0;i<tests.size();i++)
     lv1->insertItem(new qsipb_stwrapp(lv1,tests[i]));
}
//                                                                            
qsipb_stchooser::~qsipb_stchooser()
{
}
//                                                                            
vector<sipb_stest*> qsipb_stchooser::get_rez()
{
   vector<sipb_stest*> vl;
   QListViewItem* el=NULL;
   qsipb_stwrapp* el_wrapp=NULL;
   while ((el=lv2->firstChild()))
     {	
	lv2->takeItem(el);
	el_wrapp=dynamic_cast<qsipb_stwrapp*>(el);
	if (!el_wrapp)
	  qFatal("Error in qsipb_stchooser::get_rez");
	vl.push_back(el_wrapp->get());
	delete el_wrapp;
     }
   while ((el=lv1->firstChild()))
     {
	lv1->takeItem(el);
	el_wrapp=dynamic_cast<qsipb_stwrapp*>(el);
	if (!el_wrapp)
	  qFatal("Error in qsipb_stchooser::get_rez");
	delete el_wrapp->get();
	delete el_wrapp;
     }
   return vl;
}
//                                                                            
void qsipb_stchooser::want_toright()
{  //may be we can do it simply. Bat I dont now how work iterator...
   QListViewItemIterator it(lv1);
   vector<QListViewItem*> tomove;
   while (it.current()!=0)
     {
	if (lv1->isSelected(it.current()))
	  tomove.push_back(it.current());
	it++;
     }
   for (unsigned int i=0;i<tomove.size();i++)
     {
	lv1->takeItem(tomove[i]);
	lv2->insertItem(tomove[i]);
     } 
   set_selectlv2f();
}
//                                                                            
void qsipb_stchooser::want_toleft()
{
   QListViewItemIterator it(lv2);
   vector<QListViewItem*> tomove;
   while (it.current()!=0)
     {
	if (lv2->isSelected(it.current()))
	  tomove.push_back(it.current());
	it++;
     }
   for (unsigned int i=0;i<tomove.size();i++)
     {
	lv2->takeItem(tomove[i]);
	lv1->insertItem(tomove[i]);	
     }
   set_selectlv2f();
}
//                                                                            
void qsipb_stchooser::want_all()
{
   vector<QListViewItem*> tomove;
   QListViewItem* el;
   while ((el=lv1->firstChild()))
     {
	lv1->takeItem(el);
	lv2->insertItem(el);
     }
   set_selectlv2f();
}
//                                                                            
void qsipb_stchooser::want_refresh()
{
   QListViewItem* el;
   while ((el=lv2->firstChild()))
     {
	lv2->takeItem(el);
	lv1->insertItem(el);
     }
   emit rightcurr_changed(0);
}
//                                                                            
void qsipb_stchooser::want_toright(QListViewItem* it)
{
   lv1->takeItem(it);
   lv2->insertItem(it);
   lv2->setSelected(it,true);
}
//                                                                            
void qsipb_stchooser::want_toleft(QListViewItem* it)
{
   lv2->takeItem(it);
   lv1->insertItem(it);
   set_selectlv2f();
}
//                                                                            
void qsipb_stchooser::want_is_changeright(QListViewItem* it)
{
   sipb_stest *test=0;
   if (it)
     {
	qsipb_stwrapp* wr=dynamic_cast<qsipb_stwrapp*>(it);
	if (!it)
	  qFatal("Error in qsipb_stchooser::want_is_changeright");
	test=wr->get();
     }
   emit rightcurr_changed(test);
}
//                                                                            
void qsipb_stchooser::resizeEvent(QResizeEvent* r)
{
   QHBox::resizeEvent(r);
   lv1->setColumnWidth(0,(int)(lv1->width()*1.1));
   lv2->setColumnWidth(0,(int)(lv2->width()*1.1));   
}
//                                                                            
void qsipb_stchooser::set_selectlv2f()
{
   if (!lv2->firstChild())
     emit rightcurr_changed(0); 
   else
     lv2->setSelected(lv2->firstChild(),true);
}
//                                                                            
