//qsipb_stconf_dialog.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include <qmessagebox.h>
#include <qhgroupbox.h>
#include <qhgroupbox.h>
#include <qvgroupbox.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qhgroupbox.h>
#include <qpushbutton.h>
#include <qevent.h>
#include <qvalidator.h>
#include <qlabel.h>

#include "qsipb_stconf_dialog.h"
#include "sipb_stests.h"

qsipb_stconf_dialog::qsipb_stconf_dialog(sipb_paramlist gen_param_,
					 sipb_stpnkeep nk_def,
					 QWidget* parent,const char*name):
QDialog(parent,name,true)
{
   gen_param=gen_param_;
   vb_gen                      =new QVGroupBox(this);
   QHBox* hb_gen               =new QHBox(vb_gen);
   QHGroupBox*      hb_buttons =new QHGroupBox(vb_gen);

   b_run_serial       =new QPushButton("Run Serial",hb_buttons);
   b_run_parallel     =new QPushButton("Run Parallel",hb_buttons);
   b_cancel           =new QPushButton("Cancel",hb_buttons);
   
   //init chooser
   vector<sipb_stest*> tests;
   sipb_stests::create_map(tests);
   for (unsigned int i=0;i<tests.size();i++)
     tests[i]->paramlist()->copy_new_toglobal(gen_param);
   chooser             =new qsipb_stchooser(hb_gen,tests);
   
   QWidget* tmp        =new QWidget(hb_gen);
   QVBox* vb1          =new QVBox(hb_gen);
   ips                 =new qsipb_inputparamset(vb1);
   pnk                 =new qsipb_stpnkeep(vb1,nk_def);
   vb1->setStretchFactor(ips,20);
   vb1->setStretchFactor(pnk,1);
   
   hb_gen->setStretchFactor(chooser,10);
   hb_gen->setStretchFactor(vb1,10);
   hb_gen->setStretchFactor(tmp,1);
     
   connect(b_run_serial,SIGNAL(clicked()),this,SLOT(want_run_serial()));
   connect(b_run_parallel,SIGNAL(clicked()),this,SLOT(want_run_parallel()));
   connect(b_cancel,SIGNAL(clicked()),this,SLOT(reject()));
   connect(chooser,SIGNAL(rightcurr_changed(sipb_stest*)),
	   this, SLOT(want_change_right(sipb_stest*)));
   resize(800,600);
}
//                                                                            
qsipb_stconf_dialog::~qsipb_stconf_dialog()
{
   //vb_gen will delete all
}
//                                                                            
vector<sipb_stest*> qsipb_stconf_dialog::get_testlist()
{
   vector<sipb_stest*> rez=chooser->get_rez();
   for (unsigned int i=0;i<rez.size();i++)
     rez[i]->paramlist()->set_fromglobal(gen_param);   //set all global parameters
   return rez;
}
//                                                                            
void qsipb_stconf_dialog::want_run_serial()
{
   ips->make_results();
   is_run_serial=true;
   accept();
}
//                                                                            
void qsipb_stconf_dialog::want_run_parallel()
{
   ips->make_results();
   is_run_serial=false;
   accept();
}
//                                                                            
void qsipb_stconf_dialog::want_change_right(sipb_stest* test)
{
   if (test)
     ips->reset(test->paramlist(),&gen_param);
   else
     ips->make_results();
}
