//qsipb_stconf_dialog
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#ifndef __MLTD__QSIPB_STCON_DIALOG_H__
#define __MLTD__QSIPB_STCON_DIALOG_H__

#include <qdialog.h>
#include <qlineedit.h>
#include <qvgroupbox.h>
#include <qpushbutton.h>
#include "qsipb_stchooser.h"
#include "sipb_paramlist.h"
#include "qsipb_inputparamset.h"
#include "qsipb_stpnkeep.h"

class qsipb_stconf_dialog:public QDialog
  //work in modal mode!
{
   Q_OBJECT
 public:
   qsipb_stconf_dialog(sipb_paramlist gen_param, sipb_stpnkeep nk_def,
		       QWidget * parent=0, const char* name=0);
   ~qsipb_stconf_dialog();
   vector<sipb_stest*> get_testlist();
   bool          run_serial()    {return is_run_serial;};
   sipb_stpnkeep get_pnk()       {return pnk->get_rez();};
   sipb_paramlist get_gen_param(){return gen_param;};
 private slots:
   void want_run_serial();
   void want_run_parallel();
   void want_change_right(sipb_stest*);
 private:
   QVGroupBox*   vb_gen;   //we must safe it for resizeEvent
   qsipb_stchooser    *chooser;
   qsipb_inputparamset* ips;
   QPushButton        *b_run_serial,*b_run_parallel,*b_cancel;

    //specific parameters (TODO--->move it in self test)
   QLineEdit     *le_timeout,*le_n_resend,*le_n_send;
   qsipb_stpnkeep* pnk;  //packet number keep
   
   sipb_paramlist  gen_param;
   bool is_run_serial;
 private:
   void resizeEvent(QResizeEvent*ev){ vb_gen->resize(ev->size());};
};

#endif
