//qsipb_stmanager.h
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

//sipbomper simple test menager (now send-recv tests)
#ifndef __SEGER__MLTD_QSIPB_STMANAGER_H__
#define __SEGER__MLTD_QSIPB_STMANAGER_H__

#include <qlistview.h>
#include <qvgroupbox.h>
#include <qwidgetstack.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qpushbutton.h>

#include "qsipb_packetview.h"
#include "qsipb_ewshower.h"
#include "qsipb_stestinfo.h"
#include "sipb_paramlist.h"
#include "sipb_stest.h"
#include "qsipb_stpnkeep.h"


class qsipb_stmanager:public QVBox
{
   Q_OBJECT
 public:
   qsipb_stmanager(QWidget* parent=0);
   ~qsipb_stmanager(){};
   
   void run_test(vector<sipb_stest*>&); //run serial!
                   //<-- this function can be run from thread
   void test_is_complit(); //run only from qsipb_stestinfo!!!!!
 public slots:
   void want_run();          //slot for run button
   void want_stop_all();     //slot for stop_all button
   void want_stop_sel();     //slot for stop_selected button
   void want_clean_all();    //slot for clean button
   void want_clean_sel();    //slot for clean_selected_button
   void want_save_all();
   void want_save_sel();
   void want_show_test(QListViewItem*);
 public: signals:
   void is_tohandtest(sipb_stpacket&); 

   //for caption
   void is_somerun();
   void is_somestop();
 private:
   //QT objects
   QListView          *testlist;
   qsipb_packetview   *pv;
   QPushButton        *b_run, *b_stop_sel,*b_stop_all,
     *b_clean_all,*b_clean_sel,
     *b_save_all,*b_save_sel;
   
   QWidgetStack       *ews;  //stack for ew_shower
  
   sipb_stpnkeep  pnk; //number packet to keep
   sipb_paramlist gen_param;
   int last_test_id;
 private:
   vector<qsipb_stestinfo*> all_tests();
   vector<qsipb_stestinfo*> sel_tests();
   void want_stop(vector<qsipb_stestinfo*>);
   void want_clean(vector<qsipb_stestinfo*>);
   void want_save(vector<qsipb_stestinfo*>);
   void want_save(qsipb_stpwrapper*);
};

#endif
