//sipb_def.h
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)


#ifndef __SEGER__MLTD__SIPB_DEF_H__
#define __SEGER__MLTD__SIPB_DEF_H__

//parameters name (SP=SIP PARAMETER)
static const char* SIPB_SP_SIPSERVER            ="sip server";
static const char* SIPB_SP_SIPSERVER_DEF        ="127.0.0.1";

static const char* SIPB_SP_TRANSPORT            ="transport";


static const char* SIPB_SP_SERV_UDPPORT        ="udp-port";
static const char* SIPB_SP_SERV_UDPPORT_DEF    ="5060";

static const char* SIPB_SP_SERV_TCPPORT        ="tcp-port";
static const char* SIPB_SP_SERV_TCPPORT_DEF    ="5060";

static const char* SIPB_SP_LINELENGHT           ="line lenght";
static const char* SIPB_SP_LINELENGHT_DEF       ="50";

static const char* SIPB_SP_NUMBOFLINE           ="n-lines";
static const char* SIPB_SP_NUMBOFLINE_DEF       ="10";

static const char* SIPB_SP_REPARSE_RPARAM       ="reparse rand param";
static const char* SIPB_SP_REPARSE_RPARAM_DEF   ="5";
static const int   SIPB_SP_REPARSE_RPARAM_MAX   =100;

static const char* SIPB_SP_NSEND                ="n-send";
static const char* SIPB_SP_NSEND_DEF            ="1";
static const char* SIPB_SP_NSEND_CERT_DEF       ="1";


static const char* SIPB_SP_NRESEND              ="n-resend";
static const char* SIPB_SP_NRESEND_DEF          ="0";

static const char* SIPB_SP_RESEND_TIMEOUT       ="resend timeout";
static const char* SIPB_SP_RESEND_TIMEOUT_DEF   ="1000";

static const char* SIPB_SP_USERNAME             ="username";
static const char* SIPB_SP_USERNAME_DEF         ="test";

static const char* SIPB_SP_USERNAME2            ="username2";
static const char* SIPB_SP_USERNAME2_DEF        ="test2";


static const char* SIPB_SP_USERHOST_NAME        ="user host name";
static const char* SIPB_SP_USERHOST_NAME_DEF    ="sis.dorms.spbu.ru";

static const char* SIPB_SP_SGRAM_CHANGE         ="reset grammar";
static const char* SIPB_SP_SGRAM_CHANGE_DEF     ="LWS=1*WSP ; WSP=SP ; CRLF= CR LF";

static const char* SIPB_SP_MAX_CONTENT_LEN      ="max content len"; 
static const char* SIPB_SP_MAX_CONTENT_LEN_DEF  ="1024"; 

static const char* SIPB_SP_MAXCHANGELINE        ="max change line";
static const char* SIPB_SP_MAXCHANGELINE_DEF    ="5";

static const char* SIPB_SP_NUM_OF_CHANGE        ="number of change";
static const char* SIPB_SP_NUM_OF_CHANGE_DEF    ="1";

static const char* SIPB_SP_PASSWORD             ="password";
static const char* SIPB_SP_PASSWORD_DEF         ="test";

static const char* SIPB_SP_PASSWORD2            ="password2";
static const char* SIPB_SP_PASSWORD2_DEF        ="test2";


static const char* SIPB_SP_EXPIRES              ="expires";
static const char* SIPB_SP_EXPIRES_DEF          ="30";


static const char* SIPB_SP_CERT_FROM            ="CERT From";
static const char* SIPB_SP_CERT_FROM_DEF        ="test@127.0.0.1";

static const char* SIPB_SP_CERT_FROMADDRESS     ="CERT From-Address";
static const char* SIPB_SP_CERT_FROMADDRESS_DEF ="sis.dorms.spbu.ru";

static const char* SIPB_SP_CERT_FROMIP          ="CERT From-IP";
static const char* SIPB_SP_CERT_FROMIP_DEF      ="127.0.0.1";

static const char* SIPB_SP_CERT_TO              ="CERT To";
static const char* SIPB_SP_CERT_TO_DEF          ="test2@127.0.0.1";

static const char* SIPB_SP_CERT_TEARDOWNLIST    ="Teardown list";
static const char* SIPB_SP_CERT_TEARDOWNLIST_DEF="CANCEL ACK";

static const char* SIPB_SP_CERT_TESTDIR         ="testcases dir"; 
static const char* SIPB_SP_CERT_TESTDIR_DEF     ="./testcases/*"; 

static const char* SIPB_SP_CERT_TDTIMEOUT       ="teardown timeout";
static const char* SIPB_SP_CERT_TDTIMEOUT_DEF   ="200";

static const char* SIPB_SP_CERT_MID_TDTIMEOUT    ="t-t timeout";
static const char* SIPB_SP_CERT_MID_TDTIMEOUT_DEF="100";

static const char* SIPB_SP_CERT_TESTTIMEOUT     ="test timeout";
static const char* SIPB_SP_CERT_TESTTIMEOUT_DEF ="500";

static const char* SIPB_SP_MS_PAUSE             ="pause(before invite)";
static const char* SIPB_SP_MS_PAUSE_DEF         ="200";

static int SIPB_SP_MAX_INT=1000000;
static int SIPB_SP_MAX_PORT=65536;


//transports
static const char* SIPB_TRANS_UDP       ="UDP";
static const char* SIPB_TRANS_TCP       ="TCP";
static const char* SIPB_TRANS_TCP_BROKEN="TCP(broken)";
static const char* SIPB_TRANS_TCP_RANDOM="TCP(random)";
static const char* SIPB_TRANS_ANY       ="ANY";

//some usefull strings
static const char* SIPB_CRLF            ="\x0D\x0A";
static const char* SIPB_CR              ="\x0D";
static const char* SIPB_LF              ="\x0A";

//hand test
static const char* SIPB_HT_CRLF_CRLF    ="CRLF";
static const char* SIPB_HT_CRLF_CR      ="CR" ;
static const char* SIPB_HT_CRLF_LF      ="LF";

//captions 
static const char* SIPB_CAPTION_IDLE    ="Sipbomber: idle";
static const char* SIPB_CAPTION_RUNNING ="Sipbomber: running";
#endif
