//sipb_errwarn.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "sipb_errwarn.h"

void sipb_errwarn::operator+=(const sipb_errwarn& ew)
{
   for (int i=0;i<ew.err_size();i++)
     aerr.push_back(ew.err(i));
   for (int i=0;i<ew.warn_size();i++)
     awarn.push_back(ew.warn(i));
   for (int i=0;i<ew.info_size();i++)
     ainfo.push_back(ew.info(i));
}
//                                                                            
sipb_errwarn::vt sipb_errwarn::get_vt()
{
   if (err_size()>0)
     return VT_ERR;
   if (warn_size()>0)
     return VT_WARN;
   return VT_GOOD;
}
//                                                                            
sipb_errwarn::vt sipb_errwarn::add_vt(vt in_vt)
{
   if (get_vt()==VT_ERR || in_vt==VT_ERR)
     return VT_ERR;
   if (get_vt()==VT_WARN || in_vt==VT_WARN)
     return VT_WARN;
   return VT_GOOD;
}
//                                                                            
//                                                                            
