//sipb_errwarn.h
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

//Contaner contain error and warning message (and may be other type)
#ifndef __MLTD__SIPB_ERRWARN_H__
#define __MLTD__SIPB_ERRWARN_H__

#include <vector>
#include <string>

using namespace std;

class sipb_errwarn
{
 public:
   void add_warning(string str){awarn.push_back(str);};
   void add_error(string str)  {aerr.push_back(str);};
   void add_info(string str)   {ainfo.push_back(str);};
   
   int err_size()  const {return aerr.size();};
   int warn_size() const {return awarn.size();};
   int info_size() const {return ainfo.size();};
   
   const string& err(int i)   const{ return aerr.at(i); }
   const string& warn(int i)  const{ return awarn.at(i);}
   const string& info(int i)  const{ return ainfo.at(i);};
   void operator +=(const sipb_errwarn&);
   void clean(){aerr.resize(0);awarn.resize(0);ainfo.resize(0);};
 public:
   enum vt   //valid type
     {
	  VT_GOOD,
	  VT_WARN,
	  VT_ERR
     };
   vt get_vt();
   vt add_vt(vt in_vt);
 private:
   vector<string> aerr;
   vector<string> awarn;
   vector<string> ainfo;
};

#endif
