//sipb_netfun.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "sipb_netfun.h"
#include <qdatetime.h>
#include <stdexcept>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/poll.h>
#include <sys/ioctl.h>
#include <linux/sockios.h>
#include <errno.h>
#include <string.h>
#include <string>


using namespace std;  //for runtime_error

//                                                                            
void sipb_netfun::create_sockaddr_in(sockaddr_in& sock,in_addr& addr,
					   int port)
{
   bzero(&sock,sizeof(sock));
   sock.sin_family=AF_INET;
   sock.sin_port=htons(port);
   sock.sin_addr=addr;
}
//                                                                            
int sipb_netfun::get_port(int in_soc)
{
   sockaddr_in s;
   socklen_t slen=sizeof(sockaddr_in);
   if (getsockname(in_soc,(struct sockaddr*)&s,&slen)<0)
     throw runtime_error(string("Error in sipb_netfun::get_port()")
			 + strerror(errno));
   return ntohs(s.sin_port);
}
//                                                                            
sipb_netfun::poll_rez sipb_netfun::poll_inevent(int ext_soc,int ms_timeout)
{
   return poll_event(ext_soc,ms_timeout,POLLIN);
}
//                                                                            
sipb_netfun::poll_rez sipb_netfun::poll_event(int ext_soc,int ms_timeout,
					      short event)
{
   pollfd pf;
   pf.fd=ext_soc;
   QTime t;
   t.start();
   do
     {
	pf.events=event;
	int timeout=ms_timeout-t.elapsed();
	if (timeout<0)
	  timeout=0;
	int poll_out=poll(&pf,1,timeout);
	if (poll_out==0) //timeout
	  return PTIME;
	if (poll_out<0)
	  {
	     if (errno!=EINTR)  //we not receive signal 
	       throw runtime_error(string("Error in sipb_netfun::sipb_recvudp() ")+
				   "then run poll :"+strerror(errno));
	  }
	else
	  {
	     if ( (pf.revents & POLLERR) ||
		  (pf.revents & POLLHUP) ||
		  (pf.revents & POLLNVAL))
	       return PERR;
	     if (pf.revents & event)
	       return PGOOD;
	  }
     }
   while (t.elapsed()<ms_timeout);
   return PTIME;
}
//                                                                            
void sipb_netfun::bind_any(int ext_soc)
{
   in_addr addr;
   bzero(&addr,sizeof(addr));
   addr.s_addr=INADDR_ANY;
   sockaddr_in sa;
   for (int i=0;i<10000;i++)
     {
	int port=30000+random()%20000; //33000-53000
	create_sockaddr_in(sa,addr,port);
	int err=bind(ext_soc,(sockaddr*)(&sa),sizeof(sa));
	if (err>=0)
	  return;
     }
   throw runtime_error("Can't bind port");
}
