//sipb_paramlist.h
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)


#ifndef __SEGER__MLTD__SIPB_PARAMLIST_H__
#define __SEGER__MLTD__SIPB_PARAMLIST_H__
#include <qvalidator.h>
#include <vector>
#include <string>
#include "sipb_def.h"
using namespace std;

class sipb_param   //single parameter
{
 public:
   sipb_param();  //create by default
   void set(string name,bool global,string def_rez="");
   void set_int(string name,bool global,int min,int max,string def_rez="");
   void set_voriants(string name,bool global,
		     const vector<string>& vor);  //first voriant -->def
                      //vor.size() must be >0
   QValidator* create_val(QObject*parent); //may be NULL 
                                           //if not need validator
 public:
   string  name;
   string  rez;
   bool   is_global;
   
   //then set_int()
   bool   is_int;
   int    int_min;
   int    int_max;
   
   //then set_voriant
   vector<string> voriants;  //by default empty
};

class sipb_paramlist
{
 public:
   void add_wanted(string name,bool global,string def_rez="");
     //if global then parameters global by default
   void add_wanted_int(string name,bool global,int min,int max,
		       string def_rez="");
   void add_wanted_voriants(string name,bool global,const vector<string>&);
   string get(string name);   //if not found --> throw 
   int get_int(string name);
   bool check_name(string name);
   void copy_new_toglobal(sipb_paramlist& global);
      //copy only new global parameter to global (that not present in global)
   void set_fromglobal(sipb_paramlist& global);
   
   int size()                   const {return ps.size();};
   string get_name(int i)       const {return ps.at(i).name;};
   string get_rez(int i)        const {return ps.at(i).rez;};

   QValidator* create_val(QObject* parent,int i)
     {return ps.at(i).create_val(parent);}; 
     //may be NULL!!        
     //if not need validator
   
   
   bool get_is_global(int i)            const     {return ps.at(i).is_global;};
   const vector<string>&get_voriants(int i) const {return ps.at(i).voriants;};
   void set_rez(int i, string rez_str);
   void set_rez(string name,string rez_str);
   void set_is_global(int i,bool v)               {ps.at(i).is_global=v;};
 private:
   vector<sipb_param> ps;  //parameters
};

#endif
