//sipb_sendrecv_tcp.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "sipb_sendrecv_tcp.h"
#include "sipb_netfun.h"
#include <stdexcept>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/poll.h>
#include <sys/ioctl.h>
#include <linux/sockios.h>
#include <errno.h>
#include <string.h>
#include <string>

using namespace std;

sipb_sendrecv_tcp::sipb_sendrecv_tcp()
{
   if (( soc=socket(PF_INET,SOCK_STREAM,0) ) < 0)
     throw runtime_error("Error then tray create tcp-socket");
   sipb_netfun::bind_any(soc);
   _is_connect=false;
}
//                                                                            
int sipb_sendrecv_tcp::get_port()
{
   return sipb_netfun::get_port(soc);
}
//                                                                            
void sipb_sendrecv_tcp::rebind()
{
   close(soc);
   _is_connect=false;
   if (( soc=socket(PF_INET,SOCK_STREAM,0) ) < 0)
     throw runtime_error("Error then tray create tcp-socket");
   sipb_netfun::bind_any(soc);
}
//                                                                            
bool sipb_sendrecv_tcp::make_connect(in_addr addr,int port)
{
   if (is_connect())
     throw runtime_error("Error in sipb_sendrecv_tcp::make_connect already online");
   sockaddr_in sa;
   sipb_netfun::create_sockaddr_in(sa,addr,port);
   if ( connect(soc,(sockaddr*)&sa,sizeof(sa)) < 0 )
     return false;
   _is_connect=true;
   return true;
}
//                                                                            
bool sipb_sendrecv_tcp::laccept(in_addr&ip,int& port,int ms_timeout)
{
   if (is_connect())
     throw runtime_error("Error in sipb_sendrecv_tcp::laccept already online");
   if (listen(soc,5)<0)
     throw runtime_error("Error then try run listen in sipb_sendrecv_tcp::laccept "+
			 string(strerror(errno)));
   sipb_netfun::poll_rez rez=sipb_netfun::poll_inevent(soc,ms_timeout);
   if (rez == sipb_netfun::PTIME)  //timeout
     return false;
   if (rez == sipb_netfun::PERR)  //some error
     {
	_is_connect=false;
	return false;
     }
   
   sockaddr_in sa;
   socklen_t sa_len=sizeof(sa);
   int new_soc=accept(soc,(sockaddr*)&sa,&sa_len);
   if (new_soc < 0)
     throw runtime_error("Error then try run accept in sipb_sendrecv_tcp::laccept "+
			 string(strerror(errno)));
   if (sa_len!=sizeof(sa))
     throw runtime_error("Interanal error in sipb_sendrecv_tcp::laccept");
   ip=sa.sin_addr;
   port=ntohs(sa.sin_port);
   close(soc);
   soc=new_soc;
   _is_connect=true;
   return true;
}
//                                                                            
bool sipb_sendrecv_tcp::sendtcp(const string& data)
{
   if (!is_connect())
     throw logic_error("Error in sipb_sendrecv_tcp::sendtcp not connect");
   if (check_hungup())
     return false;
   //TODO: may be broken pipe (I dont known how fix it ?)
   if (send(soc,data.data(), data.size(),0)<0)
     throw runtime_error("Error then try run send in sipb_sendrecv_tcp::send "+
			 string(strerror(errno)));
   if (check_hungup())
     return false;
   return true;
}
//                                                                            
bool sipb_sendrecv_tcp::recvtcp_add(string& to_recv,int ms_timeout)
{
   if (!is_connect())
     throw logic_error("Error in sipb_sendrecv_tcp::recvtcp_add not connect");

   sipb_netfun::poll_rez rez=sipb_netfun::poll_inevent(soc,ms_timeout);
   if (check_hungup())
     return false;
   if  (rez != sipb_netfun::PGOOD)
     return false;
   int size;
   while ((size=recvbuf_size())>0) //while not empty
     {
	char* buf=new char[size];
	int out=recv(soc, buf , size ,0);
	if (out < 0)
	  throw runtime_error("Error then try run recv in sipb_sendrecv_tcp::recv_add "+
			      string(strerror(errno)));
	to_recv+=string(buf,out);
	delete buf;
     }
   return true;
}
//                                                                            
int sipb_sendrecv_tcp::recvbuf_size()
{
   int val;
   if (ioctl(soc,SIOCINQ,&val)<0)
     throw runtime_error("Error then try run ioctl in sipb_sendrecv_tcp::data_inrecvbuf "+
			 string(strerror(errno)));
   return val;
}
//                                                                            
bool sipb_sendrecv_tcp::check_hungup()
{   
   if ( sipb_netfun::poll_event(soc,0,0) == sipb_netfun::PERR ) //some error
     return true;
   return false;
}

