//sipb_transport.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "sipb_transport.h"
#include "sipb_bnfrules_forclparse.h"
#include <stdexcept>

bool sipb_transport::send(in_addr addr,int port, sipb_stpacket&pk)
{
   bool rez = send_rd(addr,port,pk.pack);
   pk.t.start();
   pk.type     =get_if();
   pk.is_send  =true;
   pk.serv_ip  =addr;
   pk.serv_port=port;
   pk.my_port  =get_port();
   pk.nsend   +=1;
   return rez;
}
//                                                                            
bool sipb_transport::recv(in_addr addr,int port,sipb_stpacket&pk,
			  int ms_timeout)
{
   bool rez=recv_rd(addr,port,pk.pack,ms_timeout);
   pk.t.start();
   pk.type     =get_if();
   pk.is_send  =false;
   pk.serv_ip  =addr;
   pk.serv_port=port;
   pk.my_port  =get_port();
   return rez;
}
//                                                                            
//                                                                            
bool sipb_udptrans::send_rd(in_addr s_ip,int s_port,const string& d)
{
   if (udp.is_connect())
     return udp.sendudp(d);
   return udp.make_connect(s_ip,s_port) && udp.sendudp(d);
}
//                                                                            
bool sipb_udptrans::recv_rd(in_addr& s_ip, int& s_port, string& d,
			 int ms_timeout)
{
   return  udp.recvudp(s_ip,s_port,d,ms_timeout);
}
//                                                                            
//                                                                            
sipb_reltrans::sipb_reltrans()
  :p(sipb_bnfrules_forclparse){}
//                                                                           
bool sipb_reltrans::send_rd(in_addr s_ip,int s_port,const string& d)
{
   if (!is_connect())
     if (!make_connect(s_ip,s_port))
       return false;
   return ec_send(d);
}
//                                                                            
bool sipb_reltrans::recv_rd(in_addr& serv_ip, int& port, string& d,
			                          int ms_timeout)
{
   if (!is_connect())  //if no connection
     if (!laccept(serv_ip,port,ms_timeout))
       return false;
   if (!is_connect())
     throw runtime_error("Internall error in sipb_reltrans::recv");
   d.resize(0);
   QTime t;
   t.start();
   do
     {
	int timeout=ms_timeout-t.elapsed();
	if (timeout<0)
	  timeout=0;
	if (!ec_recv_add(d,timeout))
	  return false;
     }
   while(!check_fix_recv(d) && ( t.elapsed() < ms_timeout ));
   return check_fix_recv(d);
}
//                                                                            
bool sipb_reltrans::check_fix_recv(string& data)
{
   if (data.size()==0)
     return false;
   bnf_parsval pv;
   if (!p.try_parse(pv,"SIP-message",data))
     return false;
   string cl_str;
   if (!pv.get_one("CL-val",cl_str))
     return false;
   bnf_parsval* pv_cont;
   if (!pv.get_one("Content",pv_cont))
     throw runtime_error("Internall error in sipb_reltrans::check_recv");

   int real_cl=pv_cont->get_data().size();
   int cl=atoi(cl_str.c_str());
   
   if (real_cl < cl)
     return false;
   data.resize(data.size() - (real_cl - cl));  //may be read more then need
   return true;
}
//                                                                            
//                                                                            
bool sipb_tcptrans::ec_send(const string& data)
{
   return tcp.sendtcp(data);
}
//                                                                            
bool sipb_tcptrans::ec_recv_add(string& data,int ms_timeout)
{
   return tcp.recvtcp_add(data,ms_timeout);
}
//                                                                            
bool sipb_tcptrans::make_connect(in_addr ip,int port)
{
   if (!is_connect())
     return tcp.make_connect(ip,port);
   return true;
}
//                                                                            
bool sipb_tcptrans::laccept(in_addr& ip,int& port,int ms_timeout)
{
   if (is_connect())
     throw runtime_error("Error in sipb_tcptrans::laccept");
   return tcp.laccept(ip,port,ms_timeout);
}
//                                                                            
