//sipb_transport.h
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

//Abstract transport
#ifndef __SEGER__MLTD__SIPB_TRANSPORT_H
#define __SEGER__MLTD__SIPB_TRANSPORT_H

#include "sipb_stpacket.h"
#include "sipb_sendrecv_tcp.h"
#include "sipb_sendrecv_udp.h"
#include "bnf_parser.h"

class sipb_transport
{
 public:
   sipb_transport(){};
   virtual ~sipb_transport(){};
   virtual void rebind()=0;
   bool send(in_addr addr, int port,sipb_stpacket&);
                   //first make connect (if not already connect)
   bool recv(in_addr addr, int port, sipb_stpacket&,
		     int ms_timeout);  //timeout in milisecond
   virtual bool is_connect()=0;
   virtual string get_if()=0;
   virtual int get_port()=0;
   virtual bool check_hungup()=0; //check error 

   virtual bool is_reliable_trans()=0;
 protected:
   virtual bool send_rd(in_addr s_ip,int s_port,const string&)=0; 
                //if connection is exist --> send over existing connection
   virtual bool recv_rd(in_addr& s_ip,int& s_port,string&,
			int ms_timeout)=0;
                //port and serv_ip may change 
                //(on input they must indicate real serv_ip and port)
};


class sipb_udptrans:public sipb_transport
{
 public:
   void rebind()               {udp.rebind();};
   virtual string get_if()     {return "UDP";};
   virtual int get_port()      {return udp.get_port();};
   virtual bool is_connect()   {return udp.is_connect();};
   virtual bool check_hungup() {return udp.check_hungup();};
   virtual bool is_reliable_trans(){return false;};
 protected:
   bool send_rd(in_addr s_ip,int s_port,const string& to_send);
   bool recv_rd(in_addr& serv_ip, int& port, string& to_recv,int ms_timeout);  
                                                 //timeout in milisecond
 private:
   sipb_sendrecv_udp udp;
};

class sipb_reltrans:public sipb_transport
{
 public:
   sipb_reltrans();
 protected:
   bool send_rd(in_addr s_ip,int s_port,const string& to_send);
   bool recv_rd(in_addr& addr,int& port,string& to_recv,int ms_timeout);
    //existing connectin send and recive
   virtual bool ec_send(const string& to_send)=0;
   virtual bool ec_recv_add(string& to_recv, int ms_timeout)=0;
   virtual bool make_connect(in_addr,int port)=0;
                                          //make connection as "client"
   virtual bool laccept(in_addr&,int& port,int ms_timeout)=0;     
                                          //make connection as "server"
   virtual bool is_reliable_trans(){return true;};
 private:
   bool check_fix_recv(string& data);
                    //find Content-Length and compare with real content
                    //data may will be modify (remove pre-crlf and over bodies) 
 //TODO:make remove pre crlf (RFC3261 7.5)
 private:
   bnf_parser p; //for get Content-Length
};

class sipb_tcptrans:public sipb_reltrans //reliable transport
{
 public:
   void rebind()       {tcp.rebind();};
   string get_if()     {return "TCP";};
   int get_port()      {return tcp.get_port();};
   bool is_connect()   {return tcp.is_connect();};//true if connection exist
   bool check_hungup() {return tcp.check_hungup();};
 protected:
   bool ec_send(const string& to_send);
   bool ec_recv_add(string& to_recv, int ms_timeout);
   bool make_connect(in_addr,int port);  //make connection as "client"
   bool laccept(in_addr&,int& port,int ms_timeout);
                                         //make connection as "server"
 private:
   sipb_sendrecv_tcp tcp;
};

#endif
