//sipb_bnftools.h
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#ifndef __SEGER__MLTD_SIPB_BNFTOOLS_H__
#define __SEGER__MLTD_SIPB_BNFTOOLS_H__
#include <string>
#include "bnf_parser.h"
#include "sipb_stpacket.h"

using namespace std;
  
class sipb_bnftools
{
 public:
   //BASE PART
   static string hstr(string in);  //ASK ->  %x41.43.4B
   static string str(string in );   //ASK -> "ASK"
   static string str(int i);
   static string rand_nalpha(int max_len);
   static string nalpha(int len);
   static string nprint(int len);
   static string crlf(){return "\x0D\x0A";};
   
   static void create_topacket(bnf_parser&p, string rule, sipb_stpacket*pack,
			       int rand_param);
   static bool create_badrequest(string& rez,bnf_parser&pcr,bnf_parser&ppc,
				 int rand_param,int max_clen,int c_quan,
				 int ntry);
   static void make_change(string&rez,int max_clen,int c_quan);
   //READ PART
   static string read_qstr(bnf_parsval* val);

   //FULLSET PART
   static void fullset_optval(bnf_parser&pcr, string servhost_name,
			      int sport, string username, string userhost_name,
			      int max_contlen,bool rand_set_cont);
                            //set rules for create Valid OPTIONS request
//   static void fullset_regval(bnf_parser&pcr, string servhost_name,
//			      int sport, string username, string userhost_name,
//			      int wport, string wif,
//			      int max_contlen);
                            //set rules for creat Valid REGISTER request
   //SET PART (add or reset rules)
   static void set_resetrules(bnf_parser& p, string rulesl,char sep);
   //rule must be separete by sep (smth=smth1 sep smth2=smth3)
   
   static void set_rulebydef(bnf_parser& p);
   static void set_message(bnf_parser&p , string rule_name,
			   string first_rule,
			   vector<string> & necess,
			   vector<string>& opt,int c_line);
   static void set_message(bnf_parser&p, string rule_name,
			   string first_rule,int c_len,
			   string nec="",string opt="",
			   bool rand_cont=true);
     //set rule
     //set all neccessery rules as necess and all opt-rules
     //you can add neccess and opt-rules
     //(run only with set_rulebydef)
     //if rand_cont then set or not content
     //first_rule - Status-Line or Request-Line. this rulest must 
     //contain CRLF at and.
   static void set_request(bnf_parser&p,int c_len,string nec="",string opt="",
			   bool rand_cont=true);
   //same but rule_name="Request"
     
   static void set_reqline(bnf_parser &p, string method, string host,
			   string user_name,int to_port);
   static void set_randhost_reqline(bnf_parser&p,string method);
   static void set_via(bnf_parser&p, string host, string tr, int port);
         
   static void set_to_nottag(bnf_parser&, string host,string user_name,
			     int to_port);   //random set or not port
   static void set_to_withtag(bnf_parser&, string host,string user_name,
			      int to_port);   //random set or not port
   
   static void set_from(bnf_parser&, string host,string user_name,
		      int to_port);   //port set or not
   static void set_contact(bnf_parser&,string host,
			   string user_name,
			   int cont_port,bool rand_setport=true,
			   string rule_name="Contact",int expir=60,bool
			   rand_setexpir=true);
                 //if  rand_setport=true we random set or not port
                 //else we set port
                 //if rand_setexpir=true --> we random set or not expir
                 //if expir<0 --> not send exipres!
   static void set_maxfor(bnf_parser&,int mf);
   static void set_cseq(bnf_parser&,string method,int val=-1);
   static void set_require(bnf_parser&,string req);
   static void set_accept(bnf_parser&,string acc);
   static void set_subject(bnf_parser&,string s);
   static void set_conttype(bnf_parser&,string s);
      //by default if val=-1 ---> random
   static void set_callid(bnf_parser&,string val="");
      //by default if val="" ---> random
   static void set_expires(bnf_parser& p,int expir=60);
   static void set_contact_star(bnf_parser&p,string rule_name);
   static void set_sip_pr(bnf_parser&,string prefix,string host,
			  string user_name="", int port=0,
			  bool rand_setport=true);
     //create rule SIP-URI-prefix
     //port may set may not (random)
     //if rand_setport and port!=0 we random set or not port
     //else if port!=0 we set port
   static bool set_auth(bnf_parser&cr, bnf_parsval* challenge, string uri,
			string username, string password, string method,
			sipb_errwarn&ew);
   static bool set_resp_fromreq(bnf_parser&cr,bnf_parsval* request,
				int status_code,string status_str,
				int cont_len,bool rand_cont,sipb_errwarn&ew);
   //set responce from request (to parser cr )
   //we set To From CallId and CSeq (end add To tag if not presend)
   //plus we set all Vias
   //plus we add unnecessary field and make Responce rule
   //(we random generate content)
   //CHECK PART
   static bool cmp_uri(bnf_parsval * v1,bnf_parsval* v2);
     //use it only for test compare sended and resived packet 
     //(not for real work)
   static bool cmp_viaparm_notrecived(bnf_parsval* v1,bnf_parsval *v2);
     //not look in recived parameter
   static bool cmp_from(bnf_parsval *v1,bnf_parsval *v2);
   static bool cmp_to_nottag(bnf_parsval *v1,bnf_parsval * v2);
     //not look in tag parameter
   static bool cmp_cseq(bnf_parsval*v1, bnf_parsval*v2);

   static void check_statuscode(bnf_parsval* pv_recv,string expect_sc,
				sipb_errwarn&ew);
   static bool check_statuscode(bnf_parsval* pv_recv,string expect_sc);
                       //simple check
   static void check_base_req(bnf_parsval*pv_recv,bnf_parsval*pv_send,
			      sipb_errwarn&ew,sipb_errwarn&ew_gen);
    //check 8.2.6.2 (rfc3262) rules  (and something more)
    //check single via
   static void check_grammar(bnf_parser& fc,bnf_parser&fp,int n_rand,int n);
   static void check_regcontact(bnf_parsval*pv_recv,bnf_parsval*pv_send,
				sipb_errwarn&ew);
         //check contact in REGISTER-responce
   //TODO:we not use this function (may be we can remove it)
   static bool cmp_addrspec_uh_port(bnf_parsval*uri1,bnf_parsval*uri2);
         //compare only userhost + port 
         //(5060 by default if port1=5060 port2="" ==> port1==port2)
   static bool find_contact_port(bnf_parsval*pv,int port);
   
   //USEFUL FUN
 public: 

   static void vec_add(string s,vector<string>&v,char sep=' ');
           //aaa bbbb -> {aaa,bbbb}
   static bool casecmp(const string& s1,const string& s2);
     //compare to string (case-insensitivity)
   
   static bool cmp_values(bnf_parsval*v1,bnf_parsval*v2,string rule, 
			  bool case_sence=1);
   static bool casecmp_values(bnf_parsval*v1,bnf_parsval*v2,string rule)
     {return cmp_values(v1,v2,rule,0);};
     //find all parsval with rule=rule and compare ('=' or casecmp)
     //if different number of parsval --> false
   static bool cmp_addrspec(bnf_parsval*v1,bnf_parsval*v2);
     //compare values=( name-addr / addr-spec )
};

class sipb_bt_challenge
{
 private:
   enum algorithm { MD5, MD5_session, other_algo };
 public:
   bool read(bnf_parsval* v,string& err); //read from bnf
      //must be realm and nonce (by default md5)
   string nonce(){return _nonce;};
   string realm(){return _realm;};
   bool is_md5() {return algo==MD5;};
 private:
   string _nonce,_realm;
   algorithm algo;
};

#endif
