//sipb_stests.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "sipb_stests.h"
#include "sipb_stest.h"
#include "sipbst.h"
#include "sipbst_cert.h"
#include <pthread.h>
#include <stdexcept>
using namespace std;

//define internal structure
class sipb_threadparam
{  
 public:
   sipb_stest*   test;
   sipb_stestinfo*  test_info; //address of may test info
};
//                                                                            
void sipb_stests::create_map(vector<sipb_stest*>& v)
{
   v.resize(0); 
   try 
     {
	v.push_back(new sipbst_garbage);
	v.push_back(new sipbst_random);
	v.push_back(new sipbst_opt_val);   
	v.push_back(new sipbst_opt_req);
	v.push_back(new sipbst_opt_bad1);
	v.push_back(new sipbst_opt_totag);
	v.push_back(new sipbst_reg_val);
	v.push_back(new sipbst_reg_exp);
	v.push_back(new sipbst_reg_del);
	v.push_back(new sipbst_reg_mcont);
	v.push_back(new sipbst_reg_mcexp);
	v.push_back(new sipbst_reg_mcdel);
	v.push_back(new sipbst_reg_cseq);
	v.push_back(new sipbst_cert);
	v.push_back(new sipbst_invsval_caller);
	v.push_back(new sipbst_invsval_callee);
     }
   catch(exception & ex)
     {
	qFatal(ex.what());
     }
}
//                                                                            
void sipb_stests::runtest(sipb_stestinfo *tinfo,sipb_stest* test)
{
   sipb_threadparam* param = new sipb_threadparam; 
   //this data will be removed by thread
   param->test     = test;
   param->test_info=tinfo;
   pthread_t thr;
   if (pthread_create(&thr,NULL,thread_run,(void*)param) != 0)
     throw runtime_error("Error in sipb_stests::runtest() can't run pthread_create");
   pthread_detach(thr);
}
//                                                                            
void* sipb_stests::thread_run(void * in_param)
{
   sipb_threadparam* param=(sipb_threadparam*)in_param;
   try
     {	
	param->test->work(param->test_info);
     }
   catch(exception& ex)
     {
	qFatal(ex.what());
     }
   delete param->test;
   delete param;
   return NULL;
}

//                                                                            
