//sipbst_grammsip.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "sipbst_grammsip.h"
#include "bnf_parser.h"
#include "sipb_bnftools.h"
#include "sipb_bnfrules_forcreate.h"
#include "sipb_bnfrules_forparse.h"
#include "sipb_addfun.h"

sipbst_grammsip::sipbst_grammsip()
{
   paramlist()->add_wanted_int(SIPB_SP_REPARSE_RPARAM,true,0,
			       SIPB_SP_REPARSE_RPARAM_MAX,
			       SIPB_SP_REPARSE_RPARAM_DEF);
   paramlist()->add_wanted(SIPB_SP_USERNAME,true,
			   SIPB_SP_USERNAME_DEF);
   paramlist()->add_wanted(SIPB_SP_USERHOST_NAME,true,
			   SIPB_SP_USERHOST_NAME_DEF);
   paramlist()->add_wanted(SIPB_SP_SGRAM_CHANGE, true,
			   SIPB_SP_SGRAM_CHANGE_DEF);
   paramlist()->add_wanted_int(SIPB_SP_MAX_CONTENT_LEN,true,0,
			       SIPB_SP_MAX_INT,
			       SIPB_SP_MAX_CONTENT_LEN_DEF);
}
//                                                                            
void sipbst_grammsip::run_beforework()
{
   pcr.load_defrule(sipb_bnfrules_forcreate);
   pps.load_defrule(sipb_bnfrules_forparse);
   ppr.load_defrule(sipb_bnfrules_forparse);
   
   rand_param=   paramlist()->get_int(SIPB_SP_REPARSE_RPARAM);
   username=     paramlist()->get(SIPB_SP_USERNAME);
   userhost_name=paramlist()->get(SIPB_SP_USERHOST_NAME);
   sgram_change= paramlist()->get(SIPB_SP_SGRAM_CHANGE);
   max_contlen=  paramlist()->get_int(SIPB_SP_MAX_CONTENT_LEN);
   try   //rule enter user and he may wrong
     {
	sipb_bnftools::set_resetrules(pcr,sgram_change,';');
	sipb_bnftools::set_resetrules(pps,sgram_change,';');
     }
   catch (exception& ex)
     {
	add_gen_error("Bad change in simple grammatic (check parameters)");
	set_wantstop();
	return;
     }
   _run_beforework();
}
//                                                                            
bool sipbst_grammsip::create_sendrecv(string rule_cr)
{
   sipb_stpacket * tosend=new sipb_stpacket;
   sipb_stpacket * torecv=new sipb_stpacket;
   sipb_bnftools::create_topacket(pcr,rule_cr,tosend,rand_param);
   if (!send_recv(tosend,torecv))
     {
	delete torecv;
	tosend->add_error("No reply for this packet");
	push_packet(tosend);
	return false;
     }
   push_packet(tosend);
   push_packet(torecv);  //we can work with last_packet
   return true;
}
//                                                                            
bool sipbst_grammsip::create_sr_parse(string r_send,string r_recv)
{
   //we not run create_sendrecv becouse we need to use tosend and torecv
   sipb_stpacket * tosend=new sipb_stpacket;
   sipb_stpacket * torecv=new sipb_stpacket;
   sipb_bnftools::create_topacket(pcr,r_send,tosend,rand_param);
   if (!send_recv(tosend,torecv))
     {
	delete torecv;
	tosend->add_error("No reply for this packet");
	push_packet(tosend);
	return false;
     }
   if (!ppr.try_parse(pv_recv,r_recv,torecv->pack))
     {
	torecv->add_error("Bad gramatic. Can't parse");
	push_packet(tosend);
	push_packet(torecv);
	return false;
     }
   if (!pps.try_parse(pv_send,r_send,tosend->pack))
     {
	tosend->add_error("Internal error! I can't parse send packet!");
	push_packet(tosend);
	push_packet(torecv);
	return false;
     }
   push_packet(tosend);
   push_packet(torecv);
   return true;
}
//                                                                            
bool sipbst_grammsip::recv_parse(string r_recv)
{
   sipb_stpacket * torecv=new sipb_stpacket;
   if (!recv(torecv))
     {
	delete torecv;
	return false;
     }
   if (!ppr.try_parse(pv_recv,r_recv,torecv->pack))
     {	
	torecv->add_error("Bad gramatic. Can't parse");
	push_packet(torecv);
	return false;
     }
   push_packet(torecv);
   return true;
}
//                                                                            
#include <iostream>
bool sipbst_grammsip::reparse_send(string rule)
{
   sipb_stpacket * tosend=new sipb_stpacket;
   sipb_bnftools::create_topacket(pcr,rule,tosend,rand_param);
   if (!send(tosend))
     {
	push_packet(tosend);
	return false;
     }
   push_packet(tosend);
   return true;
}
//                                                                            
bool sipbst_grammsip::av_csrp_reqresp(bool ignore_1xx)
{
   //add currect via parameter
   sipb_bnftools::set_via(pcr,userhost_name,get_waitif(),get_waitport());
   //create send parse
   if (!create_sr_parse("Request","Response"))
     return false;
   while (1) 
     {
	//make base check for requset
	sipb_errwarn ew_acc,ew_gen_acc;
	sipb_bnftools::check_base_req(&pv_recv,&pv_send,ew_acc,ew_gen_acc);
	add_last_errwarn(ew_acc);
	add_gen_errwarn(ew_gen_acc);
	//read status-code
	string str_status_code;
	if (!pv_recv.get_one("Status-Code",str_status_code))
	  {
	     add_last_error("Can't find status-code in responce");
	     return false;
	  }
	status_code=atoi(str_status_code.c_str());
	if (status_code<100 || status_code > 699)
	  {
	     add_last_error("Bad status-code="+str_status_code);
	     return false;
	  }
	if ( !ignore_1xx  || !is_1xx_status())
	  return true;
	add_last_warning("We recive provisional-responce after non-INVITE,"
			 "but we SHOULD NOT do it (8.2.6.1 rfc-3261)");
	if (!recv_parse()) 	//recive next packet
	  {
	     add_last_error("Not recive final-responce (only this provisional)"); 
	     return false;
	  }
     }
   return true;
}
//                                                                            
bool sipbst_grammsip::av_csrprr_auth(string method, string uri , string username,
				     string password,int max_contlen , string nec,
				     string opt,bool ignore_1xx)
{
   sipb_bnftools::set_request(pcr,random() % (max_contlen + 1),nec,opt,!is_reliable_trans());
   if (!av_csrp_reqresp(ignore_1xx))  
     return false; 
   if (status_code==403) //Forbidden
     {
	add_last_error("403 Forbidden after request, but we expect 401");
	return false;
     }
   if (status_code != 401) //Hm...
     {
	add_last_warning("We expect challenge to authorization but not recive 401");
	return true;
     }
   sipb_errwarn ew;
   if (!sipb_bnftools::set_auth(pcr, &pv_recv, uri, username, password, method,
				ew))
     {
	add_last_errwarn(ew);
	return false;
     }
   add_last_errwarn(ew);
   sipb_bnftools::set_request(pcr, random() % (max_contlen + 1),
			      nec+" Authorization",opt);

   if (!av_csrp_reqresp(ignore_1xx))
     return false;
   if (status_code==403) //Forbidden
     {
	add_last_error("403 - Forbidden after auth-request, may be bad password");
	return false;
     }
   if (status_code==401)
     {
	add_last_error("401 - after auth-request, may be bad password");
	return false;
     }
   return true;
}
//                                                                            
bool sipbst_grammsip::simple_register(string username,string password)
{
   sipb_bnftools::set_rulebydef(pcr);
   sipb_bnftools::set_reqline(pcr,"REGISTER",servhost_name,"",get_servport());
   sipb_bnftools::set_maxfor(pcr , random()%70 + 1);
   sipb_bnftools::set_cseq(pcr,"REGISTER");
   string uri=string("sip:")+username+"@"+servhost_name;
   pcr.add_rule("From",sipb_bnftools::hstr("From:" + uri));
   pcr.add_rule("To",sipb_bnftools::hstr("To:" + uri));
   pcr.add_rule("Contact",
		sipb_bnftools::hstr("Contact: <sip:"+username+"@"+
				    userhost_name+":"+
				    int_to_str(get_waitport())+
				    ">;expires=3600"));
   //TODO: may be change to this function
//   sipb_bnftools::set_from(pcr,servhost_name,username,-1);   
//   sipb_bnftools::set_to_nottag(pcr, servhost_name,username,-1);
//   sipb_bnftools::set_contact(pcr, userhost_name, username,get_waitport(),
//			      false,"Contact",3600,false); //set port and exires   
 
   if (!av_csrprr_auth("REGISTER",uri,username,password,0,"Contact"))
     {
	add_gen_error("Can't make registration: may be bad password");
	return false;
     }
   return true;
}
//                                                                            
bool sipbst_grammsip::check_2xx_status()
{
   if (!is_2xx_status())
     {
	add_last_error("We expected to recive 2xx responce but recive "+
		       int_to_str(status_code));
	return false;
     }
   return true;
}
