//sipbst_invsval_callee.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "sipbst.h"
#include "sipb_bnftools.h"
#include "sipb_addfun.h"

sipbst_invsval_callee::sipbst_invsval_callee()
{
   paramlist()->add_wanted(SIPB_SP_USERNAME2,true,SIPB_SP_USERNAME2_DEF);
   paramlist()->add_wanted(SIPB_SP_PASSWORD2,true,SIPB_SP_PASSWORD2_DEF);   
}
//                                                                            
void sipbst_invsval_callee::_run_beforework()
{
   password2=paramlist()->get(SIPB_SP_PASSWORD2);
   username2=paramlist()->get(SIPB_SP_USERNAME2);
}
//                                                                            
void sipbst_invsval_callee::_work()
{
   if (!simple_register(username2,password2))
     return;
   if (!recv_parse("Request"))
     {
	add_gen_error("We not recive INVITE. May be you not "
		      "run INVITE_sv_caller (run INVITE_sv_caller and "
		      "INVITE_sv_calle in parallel)");
	return;
     }
   sipb_errwarn ew;
   bool bool_tmp;
   if (random() % 4)  //3/4 --> send provisonal
     {
	sipb_bnftools::set_rulebydef(pcr);
	ew.clean();
	bool_tmp=
	  sipb_bnftools::set_resp_fromreq(pcr,&pv_recv,150,"My provisional",
					  random()%(1+max_contlen),true,ew);
	add_last_errwarn(ew);
	if (!bool_tmp)
	  return;
	if (!reparse_send("Response"))
	  return;
     }
   int sc_tosend;
   string sc_str_tosend;
   if (random() % 2)
     {
	sc_tosend=200;
	sc_str_tosend="Ok";
     }
   else
     {
	sc_tosend=486;
	sc_str_tosend="go away :)";
     }
   sipb_bnftools::set_rulebydef(pcr);
   ew.clean();
   bool_tmp=
     sipb_bnftools::set_resp_fromreq(pcr,&pv_recv,sc_tosend,sc_str_tosend,
				     random()%(1+max_contlen),true,ew);
   add_last_errwarn(ew);
   if (!bool_tmp)
     return;
   if (!reparse_send("Response"))
     return;
}
//                                                                            
