//sipbst_opt_req.cpp
//Copyright (C) 2003 Metalink LTD
//Author: Rodionov Sergey (seger@metalinkltd.com)
//This program is distributed under terms of GPL (see LICENSE)

#include "sipbst.h"
#include "bnf_parser.h"
#include "sipb_bnftools.h"
#include "sipb_bnfrules_forcreate.h"
#include "sipb_bnfrules_forparse.h"
#include "sipb_addfun.h"

//                                                                            
void sipbst_opt_req::_work()
{
   sipb_bnftools::set_rulebydef(pcr);
   if (random()%2)  //may be to host and maxforwards>0
     {
	sipb_bnftools::set_reqline(pcr, "OPTIONS", servhost_name,"",
				   get_servport());
	sipb_bnftools::set_maxfor(pcr,70);
     }
   else             //may be to any and maxforwards=0
     {	
	sipb_bnftools::set_randhost_reqline(pcr,"OPTIONS");
	sipb_bnftools::set_maxfor(pcr,0);
     }
   sipb_bnftools::set_via(pcr, userhost_name,get_waitif(),get_waitport());
   sipb_bnftools::set_to_nottag(pcr, servhost_name,"",get_servport());
   sipb_bnftools::set_cseq(pcr,"OPTIONS");
   sipb_bnftools::set_from(pcr,userhost_name,username,get_waitport());
   
   pcr.reset_rule("Require","\"Require\" HCOLON option-tag [COMMA option-tag ]");
   
   sipb_bnftools::set_request(pcr,random() % (max_contlen + 1),"Require",
			      "Contact Expires",!is_reliable_trans());
   
   
   if (!av_csrp_reqresp()) return;
   
   if (status_code!=420)
     {
	add_last_error("We send valid packet with"
		       " Require header, server MUST send 420 (Bad Extension) "
		       " (rfc3261 8.2.2.3) but we recive="+int_to_str(status_code));
	return;
     }
   bnf_parsval        *req,*usup;
   vector<bnf_parsval*>  ot_req,ot_usup;
   //get option-tag from send packet (get to vpv_s)
   if (!pv_send.get_one("Require",req))
     {
	add_last_error("INTERANL ERROR! Can't find Require in send packet!");
	return;
     }
   req->get("option-tag",ot_req);
   //get option-tag from recv packet (from Unsupported to vpv_r)
   if (!pv_recv.get_one("Unsupported",usup))
     {
	add_last_error("Can't find Unsuppoted header, but server MUST add it in 420-responce (rfc3261 8.2.2.3)");
	return;
     }
   usup->get("option-tag",ot_usup);
   //check all option-tag
   for (unsigned int i=0 ; i<ot_req.size() ; i++)
     {
	bool is_find=false;
	for (unsigned int j=0 ; j<ot_usup.size() ; i++)
	  {
	     if (ot_req[i]->get_data()==ot_usup[j]->get_data())
	       is_find=true;
	  }
	if (!is_find)
	  add_last_error("Can't find options-tag=" + ot_req[i]->get_data() +
			 " in Unsupported (rfc3261 8.2.2.3 for detail)");
     }
   return;
}
